/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.portal;

import io.gravitee.common.component.Lifecycle;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.RatingSummaryEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.api.ApiListItem;
import io.gravitee.rest.api.model.api.ApiQuery;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.ConfigService;
import io.gravitee.rest.api.service.RatingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

@Api(tags={"Portal APIs"})
public class PortalApisResource
extends AbstractResource {
    @Inject
    private ApiService apiService;
    @Inject
    private RatingService ratingService;
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ConfigService configService;

    @POST
    @Path(value="_search")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search for API using the search engine")
    @ApiResponses(value={@ApiResponse(code=200, message="List accessible APIs for current user", response=ApiListItem.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    public Response searchPortalApis(@ApiParam(name="q", required=true) @NotNull @QueryParam(value="q") String query) {
        try {
            Collection apis;
            ApiQuery apiQuery = new ApiQuery();
            if (this.isAdmin()) {
                apis = this.apiService.search(apiQuery);
            } else {
                apiQuery.setLifecycleStates(Collections.singletonList(ApiLifecycleState.PUBLISHED));
                if (this.isAuthenticated()) {
                    apis = this.apiService.findByUser(this.getAuthenticatedUser(), apiQuery, true);
                } else {
                    if (this.configService.portalLoginForced()) {
                        return Response.ok().entity(Collections.emptyList()).build();
                    }
                    apiQuery.setVisibility(Visibility.PUBLIC);
                    apis = this.apiService.search(apiQuery);
                }
            }
            HashMap filters = new HashMap();
            filters.put("api", apis.stream().map(ApiEntity::getId).collect(Collectors.toSet()));
            return Response.ok().entity(this.apiService.search(query, filters).stream().map(this::convert).collect(Collectors.toList())).build();
        }
        catch (TechnicalException te) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)te).build();
        }
    }

    private ApiListItem convert(ApiEntity api) {
        ApiListItem apiItem = new ApiListItem();
        apiItem.setId(api.getId());
        apiItem.setName(api.getName());
        apiItem.setVersion(api.getVersion());
        apiItem.setDescription(api.getDescription());
        UriBuilder ub = this.uriInfo.getBaseUriBuilder();
        UriBuilder uriBuilder = ub.path("apis").path(api.getId()).path("picture");
        if (api.getPicture() != null) {
            uriBuilder.queryParam("hash", new Object[]{api.getUpdatedAt().getTime()});
        }
        apiItem.setPictureUrl(uriBuilder.build(new Object[0]).toString());
        apiItem.setCategories(api.getCategories());
        apiItem.setCreatedAt(api.getCreatedAt());
        apiItem.setUpdatedAt(api.getUpdatedAt());
        apiItem.setLabels(api.getLabels());
        apiItem.setCategories(api.getCategories());
        apiItem.setPrimaryOwner(api.getPrimaryOwner());
        if (api.getVisibility() != null) {
            apiItem.setVisibility(Visibility.valueOf((String)api.getVisibility().toString()));
        }
        if (api.getState() != null) {
            apiItem.setState(Lifecycle.State.valueOf((String)api.getState().toString()));
        }
        if (api.getProxy() != null) {
            apiItem.setVirtualHosts(api.getProxy().getVirtualHosts());
        }
        if (this.ratingService.isEnabled()) {
            RatingSummaryEntity ratingSummary = this.ratingService.findSummaryByApi(api.getId());
            apiItem.setRate(ratingSummary.getAverageRate());
            apiItem.setNumberOfRatings(ratingSummary.getNumberOfRatings());
        }
        apiItem.setTags(api.getTags());
        if (api.getLifecycleState() != null) {
            apiItem.setLifecycleState(ApiLifecycleState.valueOf((String)api.getLifecycleState().toString()));
        }
        return apiItem;
    }
}

