/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.UpdateUserEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.service.NewsletterService;
import io.gravitee.rest.api.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"Newsletter"})
public class NewsletterResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private NewsletterService newsletterService;
    @Inject
    private UserService userService;

    @POST
    @Path(value="/_subscribe")
    @ApiOperation(value="Subscribe to the newsletter the authenticated user")
    @ApiResponses(value={@ApiResponse(code=200, message="Updated user", response=UserEntity.class), @ApiResponse(code=400, message="Invalid user profile"), @ApiResponse(code=404, message="User not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response subscribeNewsletterToCurrentUser(@Valid @NotNull String email) {
        UserEntity userEntity = this.userService.findById(this.getAuthenticatedUser());
        UpdateUserEntity user = new UpdateUserEntity(userEntity);
        user.setNewsletter(Boolean.valueOf(true));
        return Response.ok((Object)this.userService.update(userEntity.getId(), user, email)).build();
    }

    @GET
    @Path(value="/taglines")
    @ApiOperation(value="Get taglines to display in the newsletter")
    @ApiResponses(value={@ApiResponse(code=200, message="Retrieved taglines", response=List.class), @ApiResponse(code=500, message="Internal server error")})
    public Response getTaglines() {
        return Response.ok((Object)this.newsletterService.getTaglines()).build();
    }
}

