/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.GroupSimpleEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Api(tags={"Groups"})
public class GroupsResource
extends AbstractResource {
    @Inject
    private GroupService groupService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Find groups", notes="Find all groups for current organizationOnly administrators could see all groups.Only users with MANAGE_API permissions could see API groups.")
    @ApiResponses(value={@ApiResponse(code=200, message="List of groups", response=GroupSimpleEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.READ})})
    public Response getGroups() {
        return Response.ok((Object)this.groupService.findAllByOrganization(GraviteeContext.getCurrentOrganization())).build();
    }
}

