/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.NewTenantEntity;
import io.gravitee.rest.api.model.TenantEntity;
import io.gravitee.rest.api.model.TenantReferenceType;
import io.gravitee.rest.api.model.UpdateTenantEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.TenantService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Api(tags={"Tenants"})
public class TenantsResource
extends AbstractResource {
    @Inject
    private TenantService tenantService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List tenants")
    @ApiResponses(value={@ApiResponse(code=200, message="List of tenants", response=TenantEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    public List<TenantEntity> getTenants() {
        return this.tenantService.findByReference(GraviteeContext.getCurrentOrganization(), TenantReferenceType.ORGANIZATION).stream().sorted((o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName())).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a tenant", notes="User must have the MANAGEMENT_TENANT[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of tenants", response=TenantEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TENANT, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.ORGANIZATION_TENANT, acls={RolePermissionAction.CREATE})})
    public List<TenantEntity> createTenants(@Valid @NotNull List<NewTenantEntity> tenant) {
        return this.tenantService.create(tenant, GraviteeContext.getCurrentOrganization(), TenantReferenceType.ORGANIZATION);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a tenant", notes="User must have the MANAGEMENT_TENANT[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of tenants", response=TenantEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TENANT, acls={RolePermissionAction.UPDATE}), @Permission(value=RolePermission.ORGANIZATION_TENANT, acls={RolePermissionAction.UPDATE})})
    public List<TenantEntity> updateTenants(@Valid @NotNull List<UpdateTenantEntity> tenant) {
        return this.tenantService.update(tenant, GraviteeContext.getCurrentOrganization(), TenantReferenceType.ORGANIZATION);
    }

    @Path(value="{tenant}")
    @DELETE
    @Consumes(value={"application/json"})
    @ApiOperation(value="Delete a tenant", notes="User must have the MANAGEMENT_TENANT[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of tenants", response=TenantEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TENANT, acls={RolePermissionAction.DELETE}), @Permission(value=RolePermission.ORGANIZATION_TENANT, acls={RolePermissionAction.DELETE})})
    public void deleteTenant(@PathParam(value="tenant") String tenant) {
        this.tenantService.delete(tenant, GraviteeContext.getCurrentOrganization(), TenantReferenceType.ORGANIZATION);
    }
}

