/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.NewTagEntity;
import io.gravitee.rest.api.model.TagEntity;
import io.gravitee.rest.api.model.TagReferenceType;
import io.gravitee.rest.api.model.UpdateTagEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.TagService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Api(tags={"Sharding Tags"})
public class TagsResource
extends AbstractResource {
    @Inject
    private TagService tagService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List sharding tags")
    @ApiResponses(value={@ApiResponse(code=200, message="List of sharding tags", response=TagEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    public List<TagEntity> getTags() {
        return this.tagService.findByReference(GraviteeContext.getCurrentOrganization(), TagReferenceType.ORGANIZATION).stream().sorted((o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName())).collect(Collectors.toList());
    }

    @GET
    @Path(value="{tag}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a sharding tag", notes="User must have the MANAGEMENT_TAG[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Tag", response=TagEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TAG, acls={RolePermissionAction.READ}), @Permission(value=RolePermission.ENVIRONMENT_TAG, acls={RolePermissionAction.READ})})
    public TagEntity getTag(@PathParam(value="tag") String tag) {
        return this.tagService.findByIdAndReference(tag, GraviteeContext.getCurrentOrganization(), TagReferenceType.ORGANIZATION);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a sharding tag", notes="User must have the MANAGEMENT_TAG[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="A new sharding tag", response=TagEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TAG, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.ORGANIZATION_TAG, acls={RolePermissionAction.CREATE})})
    public TagEntity createTag(@Valid @NotNull NewTagEntity tag) {
        return this.tagService.create(tag, GraviteeContext.getCurrentOrganization(), TagReferenceType.ORGANIZATION);
    }

    @PUT
    @Path(value="{tag}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update an existing sharding tag", notes="User must have the MANAGEMENT_TAG[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Sharding tag", response=TagEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TAG, acls={RolePermissionAction.UPDATE}), @Permission(value=RolePermission.ORGANIZATION_TAG, acls={RolePermissionAction.UPDATE})})
    public TagEntity updateTag(@PathParam(value="tag") String tagId, @Valid @NotNull UpdateTagEntity tag) {
        return this.tagService.update(tag, GraviteeContext.getCurrentOrganization(), TagReferenceType.ORGANIZATION);
    }

    @Path(value="{tag}")
    @DELETE
    @Consumes(value={"application/json"})
    @ApiOperation(value="Delete an existing sharding tag", notes="User must have the MANAGEMENT_TAG[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="Sharding tag successfully deleted"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TAG, acls={RolePermissionAction.DELETE}), @Permission(value=RolePermission.ORGANIZATION_TAG, acls={RolePermissionAction.DELETE})})
    public void deleteTag(@PathParam(value="tag") String tag) {
        this.tagService.delete(tag, GraviteeContext.getCurrentOrganization(), TagReferenceType.ORGANIZATION);
    }
}

