/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.service.promotion.PromotionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"Promotion"})
public class PromotionResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private PromotionService promotionService;
    @PathParam(value="promotion")
    @ApiParam(name="promotion", required=true, value="The ID of the promotion")
    private String promotion;

    @POST
    @Path(value="/_process")
    @ApiOperation(value="Process an API promotion by accepting or rejecting it")
    @ApiResponses(value={@ApiResponse(code=200, message="Processed promotion"), @ApiResponse(code=404, message="Promotion not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response processPromotion(boolean accepted) {
        return Response.ok((Object)this.promotionService.processPromotion(this.promotion, accepted, this.getAuthenticatedUser())).build();
    }
}

