/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.FetcherResource;
import io.gravitee.rest.api.management.rest.resource.param.FetchersParam;
import io.gravitee.rest.api.model.FetcherEntity;
import io.gravitee.rest.api.model.FetcherListItem;
import io.gravitee.rest.api.service.FetcherService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"Plugins"})
public class FetchersResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private FetcherService fetcherService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List of fetcher plugins")
    @ApiResponses(value={@ApiResponse(code=200, message="List of fetchers", response=FetcherListItem.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    public Collection<FetcherListItem> getFetchers(@BeanParam FetchersParam params) {
        Stream<FetcherListItem> stream = this.fetcherService.findAll(params.isOnlyFilesFetchers()).stream().map(this::convert);
        if (params != null && params.getExpand() != null && !params.getExpand().isEmpty()) {
            Iterator<String> iterator = params.getExpand().iterator();
            while (iterator.hasNext()) {
                String s;
                switch (s = iterator.next()) {
                    case "schema": {
                        stream = stream.map(fetcherListItem -> {
                            fetcherListItem.setSchema(this.fetcherService.getSchema(fetcherListItem.getId()));
                            return fetcherListItem;
                        });
                        break;
                    }
                }
            }
        }
        return stream.sorted(Comparator.comparing(FetcherListItem::getName)).collect(Collectors.toList());
    }

    @Path(value="{fetcher}")
    public FetcherResource getFetcherResource() {
        return (FetcherResource)this.resourceContext.getResource(FetcherResource.class);
    }

    private FetcherListItem convert(FetcherEntity fetcher) {
        FetcherListItem item = new FetcherListItem();
        item.setId(fetcher.getId());
        item.setName(fetcher.getName());
        item.setDescription(fetcher.getDescription());
        item.setVersion(fetcher.getVersion());
        return item;
    }
}

