/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.spring;

import io.gravitee.common.util.RelaxedPropertySource;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class EnvironmentBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static final String[] PROPERTY_PREFIXES = new String[]{"gravitee.", "gravitee_", "GRAVITEE.", "GRAVITEE_"};

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        StandardEnvironment environment = (StandardEnvironment)beanFactory.getBean(Environment.class);
        if (environment != null) {
            Map systemEnvironment = environment.getSystemEnvironment();
            HashMap prefixlessSystemEnvironment = new HashMap(systemEnvironment.size());
            systemEnvironment.keySet().forEach(key -> {
                String prefixKey = key;
                for (String propertyPrefix : PROPERTY_PREFIXES) {
                    if (!key.startsWith(propertyPrefix)) continue;
                    prefixKey = key.substring(propertyPrefix.length());
                    break;
                }
                prefixlessSystemEnvironment.put(prefixKey, systemEnvironment.get(key));
            });
            environment.getPropertySources().replace("systemEnvironment", (PropertySource)new RelaxedPropertySource("systemEnvironment", prefixlessSystemEnvironment));
        }
    }
}

