/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.portal;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationReferenceType;
import io.gravitee.rest.api.model.configuration.identity.SocialIdentityProviderEntity;
import io.gravitee.rest.api.service.SocialIdentityProviderService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderActivationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;

@Api(tags={"Portal", "Authentication", "Identity Providers"})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SocialIdentityProvidersResource
extends AbstractResource {
    @Inject
    private SocialIdentityProviderService socialIdentityProviderService;
    @Inject
    private IdentityProviderActivationService identityProviderActivationService;

    @GET
    @ApiOperation(value="Get the list of social identity providers")
    @ApiResponses(value={@ApiResponse(code=200, message="List social identity providers", response=SocialIdentityProviderEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    public List<SocialIdentityProviderEntity> getSocialIdentityProviders() {
        return this.socialIdentityProviderService.findAll(new IdentityProviderActivationService.ActivationTarget(GraviteeContext.getCurrentOrganization(), IdentityProviderActivationReferenceType.ORGANIZATION)).stream().sorted((idp1, idp2) -> String.CASE_INSENSITIVE_ORDER.compare(idp1.getName(), idp2.getName())).collect(Collectors.toList());
    }
}

