/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.management.rest.model.Pageable;
import io.gravitee.rest.api.management.rest.model.PagedResult;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.organization.UserResource;
import io.gravitee.rest.api.management.rest.resource.organization.UsersRegistrationResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.NewExternalUserEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"Users"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class UsersResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private UserService userService;

    @GET
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.READ})})
    @ApiOperation(value="Search for users using the search engine", notes="User must have the ORGANIZATION_USERS[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List users matching the query criteria", response=PagedResult.class), @ApiResponse(code=500, message="Internal server error")})
    public PagedResult<UserEntity> getAllUsers(@ApiParam(name="q") @QueryParam(value="q") String query, @Valid @BeanParam Pageable pageable) {
        Page users = this.userService.search(query, pageable.toPageable());
        return new PagedResult<UserEntity>(users, pageable.getSize());
    }

    @POST
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.CREATE})})
    @ApiOperation(value="Create a user", notes="User must have the ORGANIZATION_USERS[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List users matching the query criteria", response=UserEntity.class), @ApiResponse(code=500, message="Internal server error")})
    public Response createUser(@Valid NewExternalUserEntity newExternalUserEntity) {
        UserEntity newUser = this.userService.create(newExternalUserEntity);
        if (newUser != null) {
            return Response.ok().entity((Object)newUser).build();
        }
        return Response.serverError().build();
    }

    @Path(value="{userId}")
    public UserResource getUserResource() {
        return (UserResource)this.resourceContext.getResource(UserResource.class);
    }

    @Path(value="registration")
    public UsersRegistrationResource getUsersRegistrationResource() {
        return (UsersRegistrationResource)this.resourceContext.getResource(UsersRegistrationResource.class);
    }
}

