/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.model.PagedResult;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.notification.PortalNotificationEntity;
import io.gravitee.rest.api.service.PortalNotificationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Api(tags={"User Notifications"})
public class UserNotificationsResource
extends AbstractResource {
    @Autowired
    private PortalNotificationService portalNotificationService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List user's notifications")
    @ApiResponses(value={@ApiResponse(code=200, message="User's notifications"), @ApiResponse(code=404, message="User not found"), @ApiResponse(code=500, message="Internal server error")})
    public PagedResult<PortalNotificationEntity> getUserNotifications() {
        List notifications = this.portalNotificationService.findByUser(this.getAuthenticatedUser()).stream().sorted(Comparator.comparing(PortalNotificationEntity::getCreatedAt)).collect(Collectors.toList());
        return new PagedResult<PortalNotificationEntity>(notifications);
    }

    @DELETE
    @ApiOperation(value="Delete all user's notifications")
    @ApiResponses(value={@ApiResponse(code=204, message="Notifications successfully deleted"), @ApiResponse(code=404, message="User not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteAllUserNotifications() {
        this.portalNotificationService.deleteAll(this.getAuthenticatedUser());
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @Path(value="{notification}")
    @DELETE
    @ApiOperation(value="Delete a single user's notification")
    @ApiResponses(value={@ApiResponse(code=204, message="Notification successfully deleted"), @ApiResponse(code=404, message="User not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteUserNotification(@PathParam(value="notification") String notificationId) {
        this.portalNotificationService.delete(notificationId);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

