/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.organization.RoleResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.NewRoleEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.RoleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"Roles"})
public class RoleScopeResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private RoleService roleService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List of roles", notes="User must have the MANAGEMENT_ROLE[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Role successfully removed", response=RoleEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_ROLE, acls={RolePermissionAction.READ})})
    public List<RoleEntity> getRoles(@PathParam(value="scope") RoleScope scope) {
        return this.roleService.findByScope(scope);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a role", notes="User must have the MANAGEMENT_ROLE[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Role successfully created", response=RoleEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_ROLE, acls={RolePermissionAction.CREATE})})
    public RoleEntity createRole(@PathParam(value="scope") RoleScope scope, @Valid @NotNull NewRoleEntity role) {
        return this.roleService.create(role);
    }

    @Path(value="{role}")
    public RoleResource getRoleResource() {
        return (RoleResource)this.resourceContext.getResource(RoleResource.class);
    }
}

