/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.settings.ConsoleSettingsEntity;
import io.gravitee.rest.api.service.ConfigService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.MaintenanceModeException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"Settings"})
public class ConsoleSettingsResource {
    @Inject
    private ConfigService configService;
    @Inject
    private ParameterService parameterService;
    @Context
    private ResourceContext resourceContext;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the console settings")
    @ApiResponses(value={@ApiResponse(code=200, message="Console configuration", response=ConsoleSettingsEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_SETTINGS, acls={RolePermissionAction.READ})})
    public ConsoleSettingsEntity getConsoleSettings() {
        return this.configService.getConsoleSettings();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Save the console settings")
    @ApiResponses(value={@ApiResponse(code=200, message="Updated console settings", response=ConsoleSettingsEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_SETTINGS, acls={RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE})})
    public Response saveConsoleSettings(@ApiParam(name="config", required=true) @NotNull ConsoleSettingsEntity consoleSettingsEntity) {
        this.checkMaintenanceMode(consoleSettingsEntity);
        this.configService.save(consoleSettingsEntity);
        return Response.ok().entity((Object)consoleSettingsEntity).build();
    }

    private void checkMaintenanceMode(ConsoleSettingsEntity consoleSettingsEntity) {
        boolean maintenanceMode = this.parameterService.findAsBoolean(Key.MAINTENANCE_MODE_ENABLED, GraviteeContext.getCurrentOrganization(), ParameterReferenceType.ORGANIZATION);
        if (maintenanceMode && (consoleSettingsEntity.getMaintenance() == null || consoleSettingsEntity.getMaintenance().getEnabled() == null || consoleSettingsEntity.getMaintenance().getEnabled().booleanValue())) {
            throw new MaintenanceModeException();
        }
    }
}

