/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.GroupResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.NewGroupEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.GroupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"Groups"})
public class GroupsResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private GroupService groupService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Find groups", notes="Find all groups, or a specific type of groups.Only administrators could see all groups.Only users with MANAGE_API permissions could see API groups.")
    @ApiResponses(value={@ApiResponse(code=200, message="List of groups", response=GroupEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.READ})})
    public Response getGroups() {
        return Response.ok((Object)this.groupService.findAll()).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Create group", notes="Create a new group.")
    @ApiResponses(value={@ApiResponse(code=201, message="Group successfully created"), @ApiResponse(code=500, message="Internal Server Error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.CREATE})})
    public Response createGroup(@ApiParam(name="group", required=true) @Valid @NotNull NewGroupEntity newGroupEntity) {
        GroupEntity groupEntity = this.groupService.create(newGroupEntity);
        if (groupEntity != null) {
            return Response.created((URI)this.getLocationHeader(groupEntity.getId())).entity((Object)groupEntity).build();
        }
        return Response.serverError().build();
    }

    @Path(value="{group}")
    public GroupResource groupResource() {
        return (GroupResource)this.resourceContext.getResource(GroupResource.class);
    }
}

