/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.management.rest.model.Pageable;
import io.gravitee.rest.api.management.rest.model.PagedResult;
import io.gravitee.rest.api.management.rest.model.Subscription;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiSubscriptionResource;
import io.gravitee.rest.api.management.rest.resource.param.ListStringParam;
import io.gravitee.rest.api.management.rest.resource.param.ListSubscriptionStatusParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApiKeyEntity;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.NewSubscriptionEntity;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.ProcessSubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.validator.CustomApiKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Api(tags={"API Subscriptions"})
public class ApiSubscriptionsResource
extends AbstractResource {
    @Inject
    private SubscriptionService subscriptionService;
    @Inject
    private ApplicationService applicationService;
    @Inject
    private PlanService planService;
    @Context
    private ResourceContext resourceContext;
    @Inject
    private UserService userService;
    @Inject
    private ApiKeyService apiKeyService;
    @Inject
    private ParameterService parameterService;
    @PathParam(value="api")
    @ApiParam(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List subscriptions for the API", notes="User must have the READ_SUBSCRIPTION permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Paged result of API's subscriptions", response=PagedResult.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public PagedResult<SubscriptionEntity> getApiSubscriptions(@BeanParam SubscriptionParam subscriptionParam, @Valid @BeanParam Pageable pageable, @ApiParam(allowableValues="keys", value="Expansion of data to return in subscriptions") @QueryParam(value="expand") List<String> expand) {
        SubscriptionQuery subscriptionQuery = subscriptionParam.toQuery();
        subscriptionQuery.setApi(this.api);
        Page subscriptions = this.subscriptionService.search(subscriptionQuery, pageable.toPageable());
        if (expand != null && !expand.isEmpty()) {
            Iterator<String> iterator = expand.iterator();
            while (iterator.hasNext()) {
                String e;
                switch (e = iterator.next()) {
                    case "keys": {
                        subscriptions.getContent().forEach(subscriptionEntity -> {
                            List keys = this.apiKeyService.findBySubscription(subscriptionEntity.getId()).stream().filter(apiKeyEntity -> !apiKeyEntity.isExpired() && !apiKeyEntity.isRevoked()).map(ApiKeyEntity::getKey).collect(Collectors.toList());
                            subscriptionEntity.setKeys(keys);
                        });
                        break;
                    }
                }
            }
        }
        PagedResult<SubscriptionEntity> result = new PagedResult<SubscriptionEntity>(subscriptions, pageable.getSize());
        result.setMetadata(this.subscriptionService.getMetadata(subscriptions.getContent()).getMetadata());
        return result;
    }

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Subscribe to a plan", notes="User must have the MANAGE_SUBSCRIPTIONS permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Subscription successfully created", response=Subscription.class), @ApiResponse(code=400, message="Bad custom API Key format or custom API Key definition disabled"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.CREATE})})
    public Response createSubscriptionToApi(@ApiParam(name="application", required=true) @NotNull @QueryParam(value="application") String application, @ApiParam(name="plan", required=true) @NotNull @QueryParam(value="plan") String plan, @ApiParam(name="customApiKey") @CustomApiKey @QueryParam(value="customApiKey") String customApiKey) {
        if (StringUtils.isNotEmpty((CharSequence)customApiKey) && !this.parameterService.findAsBoolean(Key.PLAN_SECURITY_APIKEY_CUSTOM_ALLOWED, ParameterReferenceType.ENVIRONMENT)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"You are not allowed to provide a custom API Key").build();
        }
        NewSubscriptionEntity newSubscriptionEntity = new NewSubscriptionEntity(plan, application);
        SubscriptionEntity subscription = this.subscriptionService.create(newSubscriptionEntity, customApiKey);
        if (subscription.getStatus() == SubscriptionStatus.PENDING) {
            ProcessSubscriptionEntity process = new ProcessSubscriptionEntity();
            process.setId(subscription.getId());
            process.setAccepted(true);
            process.setStartingAt(new Date());
            process.setCustomApiKey(customApiKey);
            subscription = this.subscriptionService.process(process, this.getAuthenticatedUser());
        }
        return Response.created((URI)this.getRequestUriBuilder().path(subscription.getId()).replaceQueryParam("application", null).replaceQueryParam("plan", null).build(new Object[0])).entity((Object)this.convert(subscription)).build();
    }

    @GET
    @Path(value="export")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Export API logs as CSV")
    @ApiResponses(value={@ApiResponse(code=200, message="API logs as CSV"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_LOG, acls={RolePermissionAction.READ})})
    public Response exportApiSubscriptionsLogsAsCSV(@BeanParam SubscriptionParam subscriptionParam, @Valid @BeanParam Pageable pageable) {
        PagedResult<SubscriptionEntity> subscriptions = this.getApiSubscriptions(subscriptionParam, pageable, null);
        return Response.ok((Object)this.subscriptionService.exportAsCsv(subscriptions.getData(), subscriptions.getMetadata())).header("Content-Disposition", (Object)String.format("attachment;filename=subscriptions-%s-%s.csv", this.api, System.currentTimeMillis())).build();
    }

    @Path(value="{subscription}")
    public ApiSubscriptionResource getApiSubscriptionResource() {
        return (ApiSubscriptionResource)this.resourceContext.getResource(ApiSubscriptionResource.class);
    }

    private Subscription convert(SubscriptionEntity subscriptionEntity) {
        Subscription subscription = new Subscription();
        subscription.setId(subscriptionEntity.getId());
        subscription.setCreatedAt(subscriptionEntity.getCreatedAt());
        subscription.setUpdatedAt(subscriptionEntity.getUpdatedAt());
        subscription.setStartingAt(subscriptionEntity.getStartingAt());
        subscription.setEndingAt(subscriptionEntity.getEndingAt());
        subscription.setProcessedAt(subscriptionEntity.getProcessedAt());
        subscription.setProcessedBy(subscriptionEntity.getProcessedBy());
        subscription.setReason(subscriptionEntity.getReason());
        subscription.setStatus(subscriptionEntity.getStatus());
        subscription.setSubscribedBy(new Subscription.User(subscriptionEntity.getSubscribedBy(), this.userService.findById(subscriptionEntity.getSubscribedBy()).getDisplayName()));
        PlanEntity plan = this.planService.findById(subscriptionEntity.getPlan());
        subscription.setPlan(new Subscription.Plan(plan.getId(), plan.getName()));
        ApplicationEntity application = this.applicationService.findById(subscriptionEntity.getApplication());
        subscription.setApplication(new Subscription.Application(application.getId(), application.getName(), application.getType(), application.getDescription(), new Subscription.User(application.getPrimaryOwner().getId(), application.getPrimaryOwner().getDisplayName())));
        subscription.setClosedAt(subscriptionEntity.getClosedAt());
        return subscription;
    }

    private static class SubscriptionParam {
        @QueryParam(value="plan")
        @ApiParam(value="plan")
        private ListStringParam plans;
        @QueryParam(value="application")
        @ApiParam(value="application")
        private ListStringParam applications;
        @QueryParam(value="status")
        @DefaultValue(value="accepted,pending,paused")
        @ApiModelProperty(dataType="string", allowableValues="accepted, pending, rejected, closed", value="Subscription status")
        private ListSubscriptionStatusParam status;
        @QueryParam(value="api_key")
        private String apiKey;

        private SubscriptionParam() {
        }

        public ListStringParam getPlans() {
            return this.plans;
        }

        public void setPlans(ListStringParam plans) {
            this.plans = plans;
        }

        public ListStringParam getApplications() {
            return this.applications;
        }

        public void setApplications(ListStringParam applications) {
            this.applications = applications;
        }

        public ListSubscriptionStatusParam getStatus() {
            return this.status;
        }

        public void setStatus(ListSubscriptionStatusParam status) {
            this.status = status;
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        private SubscriptionQuery toQuery() {
            SubscriptionQuery query = new SubscriptionQuery();
            if (this.plans != null && this.plans.getValue() != null) {
                query.setPlans((Collection)this.plans.getValue());
            }
            if (this.status != null) {
                query.setStatuses(this.status.getStatus());
            }
            if (this.applications != null && this.applications.getValue() != null) {
                query.setApplications((Collection)this.applications.getValue());
            }
            query.setApiKey(this.apiKey);
            return query;
        }
    }
}

