/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiPageResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.management.rest.utils.HttpHeadersUtil;
import io.gravitee.rest.api.model.ImportPageEntity;
import io.gravitee.rest.api.model.NewPageEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.AccessControlService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.exceptions.PageMarkdownTemplateActionException;
import io.gravitee.rest.api.service.exceptions.PageSystemFolderActionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(tags={"API Pages"})
public class ApiPagesResource
extends AbstractResource {
    @Inject
    private ApiService apiService;
    @Inject
    private PageService pageService;
    @Inject
    private AccessControlService accessControlService;
    @Context
    private ResourceContext resourceContext;
    @PathParam(value="api")
    @ApiParam(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List pages", notes="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of pages", response=PageEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    public List<PageEntity> getApiPages(@HeaderParam(value="Accept-Language") String acceptLang, @QueryParam(value="homepage") Boolean homepage, @QueryParam(value="type") PageType type, @QueryParam(value="parent") String parent, @QueryParam(value="name") String name, @QueryParam(value="root") Boolean rootParent, @QueryParam(value="translated") boolean translated) {
        String acceptedLocale = HttpHeadersUtil.getFirstAcceptedLocaleName(acceptLang);
        ApiEntity apiEntity = this.apiService.findById(this.api);
        if (Visibility.PUBLIC.equals((Object)apiEntity.getVisibility()) || this.hasPermission(RolePermission.API_DOCUMENTATION, this.api, RolePermissionAction.READ)) {
            return this.pageService.search(new PageQuery.Builder().api(this.api).homepage(homepage).type(type).parent(parent).name(name).rootParent(rootParent).build(), translated ? acceptedLocale : null, GraviteeContext.getCurrentEnvironment()).stream().filter(page -> this.isDisplayable(apiEntity, (PageEntity)page)).map(page -> {
                page.setGeneralConditions(this.pageService.isPageUsedAsGeneralConditions(page, this.api));
                return page;
            }).collect(Collectors.toList());
        }
        throw new ForbiddenAccessException();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a page", notes="User must have the MANAGE_PAGES permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Page successfully created", response=PageEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.CREATE})})
    public Response createApiPage(@ApiParam(name="page", required=true) @Valid @NotNull NewPageEntity newPageEntity) {
        if (newPageEntity.getType().equals((Object)PageType.SYSTEM_FOLDER)) {
            throw new PageSystemFolderActionException("Create");
        }
        if (newPageEntity.getType().equals((Object)PageType.MARKDOWN_TEMPLATE)) {
            throw new PageMarkdownTemplateActionException("Create");
        }
        int order = this.pageService.findMaxApiPageOrderByApi(this.api) + 1;
        newPageEntity.setOrder(order);
        newPageEntity.setLastContributor(this.getAuthenticatedUser());
        PageEntity newPage = this.pageService.createPage(this.api, newPageEntity, GraviteeContext.getCurrentEnvironment());
        if (newPage != null) {
            return Response.created((URI)this.getLocationHeader(newPage.getId())).entity((Object)newPage).build();
        }
        return Response.serverError().build();
    }

    @POST
    @Path(value="/_fetch")
    @Produces(value={"application/json"})
    @ApiOperation(value="Refresh all pages by calling their associated fetcher", notes="User must have the MANAGE_PAGES permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Pages successfully refreshed", response=PageEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public Response fetchAllApiPages() {
        String contributor = this.getAuthenticatedUser();
        this.pageService.fetchAll(new PageQuery.Builder().api(this.api).build(), contributor, GraviteeContext.getCurrentEnvironment());
        return Response.noContent().build();
    }

    @Path(value="{page}")
    public ApiPageResource getApiPageResource() {
        return (ApiPageResource)this.resourceContext.getResource(ApiPageResource.class);
    }

    @POST
    @Path(value="/_import")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Import pages", notes="User must be ADMIN to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Page successfully created", response=PageEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.CREATE})})
    public List<PageEntity> importApiPageFiles(@ApiParam(name="page", required=true) @Valid @NotNull ImportPageEntity pageEntity) {
        pageEntity.setLastContributor(this.getAuthenticatedUser());
        return this.pageService.importFiles(this.api, pageEntity, GraviteeContext.getCurrentEnvironment());
    }

    @PUT
    @Path(value="/_import")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Import pages", notes="User must be ADMIN to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Page successfully updated", response=PageEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.CREATE})})
    public List<PageEntity> updateApiPageImportFiles(@ApiParam(name="page", required=true) @Valid @NotNull ImportPageEntity pageEntity) {
        pageEntity.setLastContributor(this.getAuthenticatedUser());
        return this.pageService.importFiles(this.api, pageEntity, GraviteeContext.getCurrentEnvironment());
    }

    private boolean isDisplayable(ApiEntity api, PageEntity page) {
        return this.isAuthenticated() && this.isAdmin() || this.accessControlService.canAccessPageFromConsole(api, page);
    }
}

