/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.management.model.Event;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.EventSearchParam;
import io.gravitee.rest.api.management.rest.resource.param.EventTypeListParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.EventQuery;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.EventService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.BeanParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Api(tags={"API Events"})
public class ApiEventsResource
extends AbstractResource {
    @Inject
    private EventService eventService;
    @PathParam(value="api")
    @ApiParam(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get API's events", notes="User must have the MANAGE_LIFECYCLE permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="API's events"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_EVENT, acls={RolePermissionAction.READ})})
    public List<EventEntity> getApiEventsEvents(@ApiParam @DefaultValue(value="all") @QueryParam(value="type") EventTypeListParam eventTypeListParam) {
        EventQuery query = new EventQuery();
        query.setApi(this.api);
        return this.eventService.search(query).stream().filter(event -> eventTypeListParam.getEventTypes().contains(event.getType())).sorted((e1, e2) -> e2.getCreatedAt().compareTo(e1.getCreatedAt())).collect(Collectors.toList());
    }

    @GET
    @Path(value="search")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get API's events", notes="User must have the API_EVENT[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Page of API events", response=Page.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_EVENT, acls={RolePermissionAction.READ})})
    public Page<EventEntity> searchApiEvents(@ApiParam @BeanParam EventSearchParam eventSearchParam) {
        ApiEntity apiEntity = this.apiService.findById(this.api);
        HashMap<String, List<String>> properties = new HashMap<String, List<String>>();
        properties.put(Event.EventProperties.API_ID.getValue(), Arrays.asList(this.api));
        Page apiEvents = this.eventService.search(eventSearchParam.getEventTypeListParam().getEventTypes(), properties, eventSearchParam.getFrom().longValue(), eventSearchParam.getTo().longValue(), eventSearchParam.getPage().intValue(), eventSearchParam.getSize().intValue());
        apiEvents.getContent().forEach(event -> {
            Map properties1 = event.getProperties();
            event.setPayload(null);
            properties1.put("api_name", apiEntity.getName());
            properties1.put("api_version", apiEntity.getVersion());
        });
        return apiEvents;
    }
}

