/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.alert.AlertMetric;
import io.gravitee.rest.api.model.alert.AlertThreshold;
import io.gravitee.rest.api.model.alert.MetricType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Api(tags={"Alerts"})
public class AlertsResource
extends AbstractResource {
    @Path(value="metrics")
    @GET
    @ApiOperation(value="List alert metrics")
    @Produces(value={"application/json"})
    public List<AlertMetric> getAlertMetrics() {
        return Arrays.stream(MetricType.values()).map(metric -> {
            AlertMetric alertMetric = new AlertMetric();
            alertMetric.setKey(metric.name().toLowerCase());
            alertMetric.setDescription(metric.description());
            alertMetric.setThresholds(metric.thresholds().stream().map(thresholdType -> {
                AlertThreshold alertThreshold = new AlertThreshold();
                alertThreshold.setKey(thresholdType.name().toLowerCase());
                alertThreshold.setDescription(thresholdType.description());
                return alertThreshold;
            }).collect(Collectors.toList()));
            return alertMetric;
        }).collect(Collectors.toList());
    }
}

