/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.filter;

import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.exceptions.MaintenanceModeException;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@PreMatching
@Priority(value=90)
public class MaintenanceFilter
implements ContainerRequestFilter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    ParameterService parameterService;
    private Pattern organizationSettings = Pattern.compile("organizations/[^/]+/settings");

    public void filter(ContainerRequestContext requestContext) throws IOException {
        boolean maintenanceModeEnabled = this.parameterService.findAsBoolean(Key.MAINTENANCE_MODE_ENABLED, ParameterReferenceType.ORGANIZATION);
        if (maintenanceModeEnabled && this.organizationSettings.matcher(requestContext.getUriInfo().getPath()).matches() && "POST".equals(requestContext.getRequest().getMethod())) {
            return;
        }
        if (maintenanceModeEnabled && !requestContext.getUriInfo().getPath().equals("portal") && !requestContext.getUriInfo().getPath().equals("portal/")) {
            throw new MaintenanceModeException();
        }
    }
}

