/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.idp.ldap.lookup;

import io.gravitee.rest.api.idp.api.identity.IdentityLookup;
import io.gravitee.rest.api.idp.api.identity.IdentityReference;
import io.gravitee.rest.api.idp.api.identity.User;
import io.gravitee.rest.api.idp.ldap.lookup.LdapUser;
import io.gravitee.rest.api.idp.ldap.lookup.spring.LdapIdentityLookupConfiguration;
import io.gravitee.rest.api.idp.ldap.utils.LdapUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.naming.Name;
import javax.naming.ldap.LdapName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.ldap.CommunicationException;
import org.springframework.ldap.LimitExceededException;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.AbstractContextMapper;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.HardcodedFilter;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.ldap.query.SearchScope;
import org.springframework.ldap.support.LdapNameBuilder;

@Import(value={LdapIdentityLookupConfiguration.class})
public class LdapIdentityLookup
implements IdentityLookup,
InitializingBean {
    private final Logger LOGGER = LoggerFactory.getLogger(LdapIdentityLookup.class);
    private static final String LDAP_ATTRIBUTE_GIVENNAME = "givenName";
    private static final String LDAP_ATTRIBUTE_SURNAME = "sn";
    private static final String LDAP_ATTRIBUTE_MAIL = "mail";
    private static final String LDAP_ATTRIBUTE_DISPLAYNAME = "displayName";
    private static final String LDAP_DEFAULT_LOOKUP_FILTER = "(&(objectClass=Person)(|(cn=*{0}*)(uid={0})))";
    @Autowired
    private LdapTemplate ldapTemplate;
    @Autowired
    private Environment environment;
    private String identifierAttribute;
    private LdapName baseDn;
    private String[] userAttributes;
    private final ContextMapper<User> USER_CONTEXT_MAPPER = new AbstractContextMapper<User>(){

        protected User doMapFromContext(DirContextOperations ctx) {
            LdapUser user = new LdapUser(ctx.getDn().toString());
            user.setFirstname(ctx.getStringAttribute(LdapIdentityLookup.LDAP_ATTRIBUTE_GIVENNAME));
            user.setLastname(ctx.getStringAttribute(LdapIdentityLookup.LDAP_ATTRIBUTE_SURNAME));
            user.setEmail(ctx.getStringAttribute(LdapIdentityLookup.LDAP_ATTRIBUTE_MAIL));
            user.setDisplayName(ctx.getStringAttribute(LdapIdentityLookup.LDAP_ATTRIBUTE_DISPLAYNAME));
            if (user.getDisplayName() == null) {
                user.setDisplayName(user.getFirstname() + " " + user.getLastname());
            }
            return user;
        }
    };

    public void afterPropertiesSet() throws Exception {
        String searchFilter = this.environment.getProperty("lookup.user.filter");
        this.LOGGER.debug("Looking for a LDAP user's identifier using search filter [{}]", (Object)searchFilter);
        if (searchFilter != null) {
            this.identifierAttribute = LdapUtils.extractAttribute(searchFilter);
            this.LOGGER.info("User identifier is based on the [{}] attribute", (Object)this.identifierAttribute);
            this.userAttributes = new String[]{this.identifierAttribute, LDAP_ATTRIBUTE_GIVENNAME, LDAP_ATTRIBUTE_SURNAME, LDAP_ATTRIBUTE_MAIL, LDAP_ATTRIBUTE_DISPLAYNAME};
        } else {
            this.userAttributes = new String[]{LDAP_ATTRIBUTE_GIVENNAME, LDAP_ATTRIBUTE_SURNAME, LDAP_ATTRIBUTE_MAIL, LDAP_ATTRIBUTE_DISPLAYNAME};
        }
        this.baseDn = LdapNameBuilder.newInstance((String)this.environment.getProperty("context.base")).add(this.environment.getProperty("lookup.user.base", "")).build();
        this.LOGGER.info("User search is based on DN [{}]", (Object)this.baseDn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<User> search(String query) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            String usersSearchFilter = this.environment.getProperty("lookup.user.filter", LDAP_DEFAULT_LOOKUP_FILTER);
            String hardcodedFilter = usersSearchFilter.replaceAll("\\{0}", LdapUtils.addWhitespaceWildcards(query));
            LdapQuery ldapQuery = LdapQueryBuilder.query().base((Name)this.baseDn).countLimit(20).timeLimit(5000).searchScope(SearchScope.SUBTREE).attributes(new String[]{LDAP_ATTRIBUTE_GIVENNAME, LDAP_ATTRIBUTE_SURNAME, LDAP_ATTRIBUTE_MAIL, LDAP_ATTRIBUTE_DISPLAYNAME}).filter((Filter)new HardcodedFilter(hardcodedFilter));
            List list = this.ldapTemplate.search(ldapQuery, this.USER_CONTEXT_MAPPER);
            return list;
        }
        catch (LimitExceededException lee) {
            this.LOGGER.info("Too much results while searching for [{}]. Returns an empty list.", (Object)query);
            List<User> list = Collections.emptyList();
            return list;
        }
        catch (CommunicationException ce) {
            this.LOGGER.error("LDAP server is not reachable.");
            List<User> list = Collections.emptyList();
            return list;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public boolean canHandle(IdentityReference identityReference) {
        return "ldap".equalsIgnoreCase(identityReference.getSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User retrieve(IdentityReference identityReference) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            User user = (User)this.ldapTemplate.lookup(identityReference.getReference(), this.userAttributes, this.USER_CONTEXT_MAPPER);
            return user;
        }
        catch (NameNotFoundException nnfe) {
            User user = null;
            return user;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public boolean allowEmailInSearchResults() {
        Boolean allow = (Boolean)this.environment.getProperty("lookup.allow-email-in-search-results", Boolean.class, (Object)false);
        return allow != null && allow != false;
    }

    public int getOrder() {
        return 30;
    }
}

