/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.idp.ldap.lookup;

import java.io.IOException;
import java.net.ServerSocket;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.env.Environment;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.server.ApacheDSContainer;

public class LdapContextSourceFactory
extends AbstractFactoryBean<LdapContextSource> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LdapContextSourceFactory.class);
    @Autowired
    private Environment environment;
    private LdapContextSource ldapContextSource;
    private ApacheDSContainer apacheDsContainer;

    public Class<?> getObjectType() {
        return LdapContextSource.class;
    }

    protected LdapContextSource createInstance() throws Exception {
        ContextSourceBuilder contextSourceBuilder = new ContextSourceBuilder();
        contextSourceBuilder.root(this.environment.getProperty("context.base"));
        if (((Boolean)this.environment.getProperty("embedded", Boolean.TYPE, (Object)false)).booleanValue()) {
            contextSourceBuilder.ldif("classpath:/ldap/gravitee-io-management-rest-api-ldap-test.ldif");
        } else {
            contextSourceBuilder.managerDn(this.environment.getProperty("context.username")).managerPassword(this.environment.getProperty("context.password")).url(this.environment.getProperty("context.url"));
        }
        this.ldapContextSource = contextSourceBuilder.build();
        return this.ldapContextSource;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.ldapContextSource.afterPropertiesSet();
        if (this.apacheDsContainer != null) {
            this.apacheDsContainer.afterPropertiesSet();
        }
    }

    public void destroy() throws Exception {
        super.destroy();
        if (this.apacheDsContainer != null) {
            this.apacheDsContainer.destroy();
        }
    }

    public final class ContextSourceBuilder {
        private String ldif = "classpath*:*.ldif";
        private String managerPassword;
        private String managerDn;
        private Integer port;
        private static final int DEFAULT_PORT = 33389;
        private String root = "dc=springframework,dc=org";
        private String url;

        public ContextSourceBuilder ldif(String ldif) {
            this.ldif = ldif;
            return this;
        }

        public ContextSourceBuilder managerDn(String managerDn) {
            this.managerDn = managerDn;
            return this;
        }

        public ContextSourceBuilder managerPassword(String managerPassword) {
            this.managerPassword = managerPassword;
            return this;
        }

        public ContextSourceBuilder port(int port) {
            this.port = port;
            return this;
        }

        public ContextSourceBuilder root(String root) {
            this.root = root;
            return this;
        }

        public ContextSourceBuilder url(String url) {
            this.url = url;
            return this;
        }

        private DefaultSpringSecurityContextSource build() throws Exception {
            DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(this.getProviderUrl());
            if (this.managerDn != null) {
                contextSource.setUserDn(this.managerDn);
                if (this.managerPassword == null) {
                    throw new IllegalStateException("managerPassword is required if managerDn is supplied");
                }
                contextSource.setPassword(this.managerPassword);
            }
            if (this.url != null) {
                return contextSource;
            }
            ApacheDSContainer embeddedApacheContainer = new ApacheDSContainer(this.root, this.ldif);
            embeddedApacheContainer.setPort(this.getPort());
            LdapContextSourceFactory.this.apacheDsContainer = embeddedApacheContainer;
            return contextSource;
        }

        private int getPort() {
            if (this.port == null) {
                this.port = this.getDefaultPort();
            }
            return this.port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getDefaultPort() {
            ServerSocket serverSocket = null;
            try {
                try {
                    serverSocket = new ServerSocket(33389);
                }
                catch (IOException e) {
                    try {
                        serverSocket = new ServerSocket(0);
                    }
                    catch (IOException e2) {
                        int n = 33389;
                        if (serverSocket != null) {
                            try {
                                serverSocket.close();
                            }
                            catch (IOException e3) {
                                log.debug("IOException ignored in LdapContextSourceFactory: {}", (Object)e3.getMessage(), (Object)e3);
                            }
                        }
                        return n;
                    }
                }
                int n = serverSocket.getLocalPort();
                return n;
            }
            finally {
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException e) {
                        log.debug("IOException ignored in LdapContextSourceFactory: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
        }

        private String getProviderUrl() {
            if (this.url == null) {
                return "ldap://127.0.0.1:" + this.getPort() + "/" + this.root;
            }
            return this.url;
        }

        private ContextSourceBuilder() {
        }
    }
}

