/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.idp.ldap.authentication;

import io.gravitee.rest.api.idp.api.authentication.AuthenticationProvider;
import io.gravitee.rest.api.idp.ldap.authentication.LdapAuthenticationProviderConfigurer;
import io.gravitee.rest.api.idp.ldap.authentication.UserDetailsContextPropertiesMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class LdapAuthenticationProvider
implements AuthenticationProvider<SecurityConfigurer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapAuthenticationProvider.class);
    @Autowired
    private Environment environment;

    public SecurityConfigurer configure() throws Exception {
        LOGGER.info("Configuring an LDAP Identity Provider");
        LdapAuthenticationProviderConfigurer ldapAuthenticationProviderConfigurer = new LdapAuthenticationProviderConfigurer();
        DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(this.environment.getProperty("context.url"));
        contextSource.setBase(this.environment.getProperty("context.base"));
        contextSource.setUserDn(this.environment.getProperty("context.username"));
        contextSource.setPassword(this.environment.getProperty("context.password"));
        contextSource.afterPropertiesSet();
        ldapAuthenticationProviderConfigurer.userSearchBase(this.environment.getProperty("authentication.user.base", "")).userSearchFilter(this.environment.getProperty("authentication.user.filter")).groupSearchBase(this.environment.getProperty("authentication.group.base", "")).groupSearchFilter(this.environment.getProperty("authentication.group.filter", "(uniqueMember={0})")).groupRoleAttribute(this.environment.getProperty("authentication.group.role.attribute", "cn")).rolePrefix("");
        DefaultLdapAuthoritiesPopulator populator = new DefaultLdapAuthoritiesPopulator((ContextSource)contextSource, this.environment.getProperty("authentication.group.base", ""));
        populator.setRolePrefix("");
        populator.setGroupRoleAttribute(this.environment.getProperty("authentication.group.role.attribute", "cn"));
        populator.setGroupSearchFilter(this.environment.getProperty("authentication.group.filter", "(uniqueMember={0})"));
        ldapAuthenticationProviderConfigurer.ldapAuthoritiesPopulator((LdapAuthoritiesPopulator)populator).contextSource((BaseLdapPathContextSource)contextSource);
        UserDetailsContextPropertiesMapper userDetailsContextPropertiesMapper = new UserDetailsContextPropertiesMapper();
        userDetailsContextPropertiesMapper.setEnvironment(this.environment);
        userDetailsContextPropertiesMapper.afterPropertiesSet();
        ldapAuthenticationProviderConfigurer.userDetailsContextMapper(userDetailsContextPropertiesMapper);
        return ldapAuthenticationProviderConfigurer;
    }
}

