/*
 * Decompiled with CFR 0.152.
 */
package assertions;

import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.analytics.Analytics;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.flow.execution.FlowExecution;
import io.gravitee.definition.model.v4.property.Property;
import io.gravitee.definition.model.v4.resource.Resource;
import io.gravitee.definition.model.v4.service.ApiServices;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.AbstractObjectAssert;

public class ApiEntityAssert
extends AbstractObjectAssert<ApiEntityAssert, ApiEntity> {
    public ApiEntityAssert(ApiEntity apiEntity) {
        super((Object)apiEntity, ApiEntityAssert.class);
    }

    public ApiEntityAssert hasId(String id) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getId().equals(id)) {
            this.failWithMessage("Expected api id to be <%s> but was <%s>", new Object[]{id, ((ApiEntity)this.actual).getId()});
        }
        return this;
    }

    public ApiEntityAssert hasNoCrossId() {
        this.isNotNull();
        if (((ApiEntity)this.actual).getCrossId() != null) {
            this.failWithMessage("Expected api cross id to be null but was <%s>", new Object[]{((ApiEntity)this.actual).getCrossId()});
        }
        return this;
    }

    public ApiEntityAssert hasCrossId(String crossId) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getCrossId().equals(crossId)) {
            this.failWithMessage("Expected api cross id to be <%s> but was <%s>", new Object[]{crossId, ((ApiEntity)this.actual).getCrossId()});
        }
        return this;
    }

    public ApiEntityAssert hasApiVersion(String apiVersion) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getApiVersion().equals(apiVersion)) {
            this.failWithMessage("Expected api version to be <%s> but was <%s>", new Object[]{apiVersion, ((ApiEntity)this.actual).getApiVersion()});
        }
        return this;
    }

    public ApiEntityAssert hasDefinitionVersion(DefinitionVersion definitionVersion) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getDefinitionVersion().equals((Object)definitionVersion)) {
            this.failWithMessage("Expected api definition version to be <%s> but was <%s>", new Object[]{definitionVersion, ((ApiEntity)this.actual).getDefinitionVersion()});
        }
        return this;
    }

    public ApiEntityAssert hasName(String name) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getName().equals(name)) {
            this.failWithMessage("Expected api name to be <%s> but was <%s>", new Object[]{name, ((ApiEntity)this.actual).getName()});
        }
        return this;
    }

    public ApiEntityAssert hasType(ApiType type) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getType().equals((Object)type)) {
            this.failWithMessage("Expected api type to be <%s> but was <%s>", new Object[]{type, ((ApiEntity)this.actual).getType()});
        }
        return this;
    }

    public ApiEntityAssert hasDescription(String description) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getDescription().equals(description)) {
            this.failWithMessage("Expected api description to be <%s> but was <%s>", new Object[]{description, ((ApiEntity)this.actual).getDescription()});
        }
        return this;
    }

    public ApiEntityAssert hasOnlyTags(Set<String> tags) {
        this.isNotNull();
        String assertjErrorMessage = "Expecting api to have tags:  <%s> but was: <%s>";
        if (!((ApiEntity)this.actual).getTags().containsAll(tags)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{tags, ((ApiEntity)this.actual).getTags()});
        }
        return this;
    }

    public ApiEntityAssert hasOnlyEndpointGroups(List<EndpointGroup> endpointGroups) {
        this.isNotNull();
        String assertjErrorMessage = "Expecting api to have endpoint groups:  <%s> but was: <%s>";
        if (!((ApiEntity)this.actual).getEndpointGroups().equals(endpointGroups)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{endpointGroups, ((ApiEntity)this.actual).getEndpointGroups()});
        }
        return this;
    }

    public ApiEntityAssert hasAnalytics(Analytics analytics) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getAnalytics().equals((Object)analytics)) {
            this.failWithMessage("Expected api analytics to be <%s> but was <%s>", new Object[]{analytics, ((ApiEntity)this.actual).getAnalytics()});
        }
        return this;
    }

    public ApiEntityAssert hasOnlyProperties(List<Property> properties) {
        this.isNotNull();
        String assertjErrorMessage = "Expecting api to have properties:  <%s> but was: <%s>";
        if (!((ApiEntity)this.actual).getProperties().equals(properties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{properties, ((ApiEntity)this.actual).getProperties()});
        }
        return this;
    }

    public ApiEntityAssert hasOnlyResources(List<Resource> resources) {
        this.isNotNull();
        String assertjErrorMessage = "Expecting api to have resources:  <%s> but was: <%s>";
        if (!((ApiEntity)this.actual).getResources().equals(resources)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{resources, ((ApiEntity)this.actual).getResources()});
        }
        return this;
    }

    public ApiEntityAssert hasNoPlan() {
        this.isNotNull();
        if (((ApiEntity)this.actual).getPlans() != null && !((ApiEntity)this.actual).getPlans().isEmpty()) {
            this.failWithMessage("Expected api to have no plan but was <%s>", new Object[]{((ApiEntity)this.actual).getPlans()});
        }
        return this;
    }

    public ApiEntityAssert hasOnlyPlans(Set<PlanEntity> plans) {
        this.isNotNull();
        String assertjErrorMessage = "Expecting api to have plans:  <%s> but was: <%s>";
        if (!((ApiEntity)this.actual).getPlans().equals(plans)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{plans, ((ApiEntity)this.actual).getPlans()});
        }
        return this;
    }

    public ApiEntityAssert hasFlowExecution(FlowExecution flowExecution) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getFlowExecution().equals((Object)flowExecution)) {
            this.failWithMessage("Expected api flow execution to be <%s> but was <%s>", new Object[]{flowExecution, ((ApiEntity)this.actual).getFlowExecution()});
        }
        return this;
    }

    public ApiEntityAssert hasOnlyFlows(List<Flow> flows) {
        this.isNotNull();
        String assertjErrorMessage = "Expecting api to have flows:  <%s> but was: <%s>";
        if (!((ApiEntity)this.actual).getFlows().equals(flows)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{flows, ((ApiEntity)this.actual).getFlows()});
        }
        return this;
    }

    public ApiEntityAssert hasOnlyResponseTemplatesKeys(Set<String> responseTemplateKeys) {
        this.isNotNull();
        String assertjErrorMessage = "Expecting api to have responseTemplate:  <%s> but was: <%s>";
        if (!((ApiEntity)this.actual).getResponseTemplates().keySet().equals(responseTemplateKeys)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{responseTemplateKeys, ((ApiEntity)this.actual).getResponseTemplates().keySet()});
        }
        return this;
    }

    public ApiEntityAssert hasServices(ApiServices services) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getServices().equals((Object)services)) {
            this.failWithMessage("Expected api services to be <%s> but was <%s>", new Object[]{services, ((ApiEntity)this.actual).getServices()});
        }
        return this;
    }

    public ApiEntityAssert hasOnlyGroups(Set<String> groups) {
        this.isNotNull();
        String assertjErrorMessage = "Expecting api to have groups:  <%s> but was: <%s>";
        if (!((ApiEntity)this.actual).getGroups().equals(groups)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{groups, ((ApiEntity)this.actual).getGroups()});
        }
        return this;
    }

    public ApiEntityAssert hasNoGroup() {
        this.isNotNull();
        if (((ApiEntity)this.actual).getGroups() != null && !((ApiEntity)this.actual).getGroups().isEmpty()) {
            this.failWithMessage("Expected api to have no group but was <%s>", new Object[]{((ApiEntity)this.actual).getGroups()});
        }
        return this;
    }

    public ApiEntityAssert hasVisibility(Visibility visibility) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getVisibility().equals((Object)visibility)) {
            this.failWithMessage("Expected api visibility to be <%s> but was <%s>", new Object[]{visibility, ((ApiEntity)this.actual).getVisibility()});
        }
        return this;
    }

    public ApiEntityAssert hasState(Lifecycle.State state) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getState().equals((Object)state)) {
            this.failWithMessage("Expected api state to be <%s> but was <%s>", new Object[]{state, ((ApiEntity)this.actual).getState()});
        }
        return this;
    }

    public ApiEntityAssert hasPrimaryOwner(PrimaryOwnerEntity primaryOwnerEntity) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getPrimaryOwner().equals((Object)primaryOwnerEntity)) {
            this.failWithMessage("Expected api primary owner to be <%s> but was <%s>", new Object[]{primaryOwnerEntity, ((ApiEntity)this.actual).getPrimaryOwner()});
        }
        return this;
    }

    public ApiEntityAssert hasPicture(String picture) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getPicture().equals(picture)) {
            this.failWithMessage("Expected api picture to be <%s> but was <%s>", new Object[]{picture, ((ApiEntity)this.actual).getPicture()});
        }
        return this;
    }

    public ApiEntityAssert hasPictureUrl(String pictureUrl) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getPictureUrl().equals(pictureUrl)) {
            this.failWithMessage("Expected api picture url to be <%s> but was <%s>", new Object[]{pictureUrl, ((ApiEntity)this.actual).getPictureUrl()});
        }
        return this;
    }

    public ApiEntityAssert hasOnlyCategories(Set<String> categories) {
        this.isNotNull();
        String assertjErrorMessage = "Expecting api to have categories:  <%s> but was: <%s>";
        if (!((ApiEntity)this.actual).getCategories().equals(categories)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{categories, ((ApiEntity)this.actual).getCategories()});
        }
        return this;
    }

    public ApiEntityAssert hasOnlyLabels(List<String> labels) {
        this.isNotNull();
        String assertjErrorMessage = "Expecting api to have labels:  <%s> but was: <%s>";
        if (!((ApiEntity)this.actual).getLabels().equals(labels)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{labels, ((ApiEntity)this.actual).getLabels()});
        }
        return this;
    }

    public ApiEntityAssert hasOriginContext(OriginContext originContext) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getOriginContext().equals(originContext)) {
            this.failWithMessage("Expected api origin context to be <%s> but was <%s>", new Object[]{originContext, ((ApiEntity)this.actual).getOriginContext()});
        }
        return this;
    }

    public ApiEntityAssert hasOnlyMetadataKeys(Set<String> metadataKeys) {
        this.isNotNull();
        String assertjErrorMessage = "Expecting api to have metadata:  <%s> but was: <%s>";
        if (!((ApiEntity)this.actual).getMetadata().keySet().equals(metadataKeys)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{metadataKeys, ((ApiEntity)this.actual).getMetadata().keySet()});
        }
        return this;
    }

    public ApiEntityAssert hasLifecycleState(ApiLifecycleState state) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getLifecycleState().equals((Object)state)) {
            this.failWithMessage("Expected api lifecycle state to be <%s> but was <%s>", new Object[]{state, ((ApiEntity)this.actual).getLifecycleState()});
        }
        return this;
    }

    public ApiEntityAssert hasWorkflowState(WorkflowState state) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getWorkflowState().equals((Object)state)) {
            this.failWithMessage("Expected api workflow state to be <%s> but was <%s>", new Object[]{state, ((ApiEntity)this.actual).getWorkflowState()});
        }
        return this;
    }

    public ApiEntityAssert hasDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).isDisableMembershipNotifications() == disableMembershipNotifications) {
            this.failWithMessage("Expected api disable membership notifications to be <%s> but was <%s>", new Object[]{disableMembershipNotifications, ((ApiEntity)this.actual).isDisableMembershipNotifications()});
        }
        return this;
    }

    public ApiEntityAssert hasBackground(String background) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getBackground().equals(background)) {
            this.failWithMessage("Expected api background to be <%s> but was <%s>", new Object[]{background, ((ApiEntity)this.actual).getBackground()});
        }
        return this;
    }

    public ApiEntityAssert hasBackgroundUrl(String backgroundUrl) {
        this.isNotNull();
        if (!((ApiEntity)this.actual).getBackgroundUrl().equals(backgroundUrl)) {
            this.failWithMessage("Expected api background url to be <%s> but was <%s>", new Object[]{backgroundUrl, ((ApiEntity)this.actual).getBackgroundUrl()});
        }
        return this;
    }
}

