/*
 * Decompiled with CFR 0.152.
 */
package fixtures.repository;

import io.gravitee.rest.api.model.v4.connector.ConnectorType;
import io.gravitee.rest.api.model.v4.log.message.BaseMessageLog;
import io.gravitee.rest.api.model.v4.log.message.MessageOperation;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class MessageLogFixtures {
    private static Supplier<BaseMessageLog.BaseMessageLogBuilder<?, ?>> BASE_BUILDER_SUPPLIER = () -> BaseMessageLog.builder().apiId("api-id").requestId("request-id").clientIdentifier("client-identifier").correlationId("correlation-id").parentCorrelationId("parent-correlation-id").operation(MessageOperation.SUBSCRIBE).connectorType(ConnectorType.ENTRYPOINT).connectorId("http-get").message(BaseMessageLog.Message.builder().id("message-id").payload("message-payload").isError(false).headers(Map.of("X-Header", List.of("header-value"))).metadata(Map.of("X-Metdata", "metadata-value")).build()).timestamp("2020-02-01T20:00:00.00Z");
    private final BaseMessageLog.BaseMessageLogBuilder<?, ?> initialMessageBuilder;

    public MessageLogFixtures(String defaultApiId) {
        this.initialMessageBuilder = BASE_BUILDER_SUPPLIER.get().apiId(defaultApiId);
    }

    public MessageLogFixtures(String defaultApiId, String defaultRequestId) {
        this.initialMessageBuilder = BASE_BUILDER_SUPPLIER.get().apiId(defaultApiId).requestId(defaultRequestId);
    }

    public BaseMessageLog aMessageLog() {
        return this.initialMessageBuilder.build();
    }

    public BaseMessageLog aMessageLogWithMessageId(String messageId) {
        BaseMessageLog messageLog = this.initialMessageBuilder.build();
        messageLog.setMessage(messageLog.getMessage().toBuilder().id(messageId).build());
        return messageLog;
    }

    public BaseMessageLog aMessageLog(String requestId) {
        return this.initialMessageBuilder.requestId(requestId).build();
    }
}

