/*
 * Decompiled with CFR 0.152.
 */
package fixtures;

import io.gravitee.definition.model.Endpoint;
import io.gravitee.definition.model.EndpointGroup;
import io.gravitee.definition.model.services.healthcheck.EndpointHealthCheckService;
import io.gravitee.definition.model.v4.endpointgroup.Endpoint;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.definition.model.v4.endpointgroup.loadbalancer.LoadBalancer;
import io.gravitee.definition.model.v4.endpointgroup.loadbalancer.LoadBalancerType;
import io.gravitee.definition.model.v4.endpointgroup.service.EndpointGroupServices;
import io.gravitee.definition.model.v4.endpointgroup.service.EndpointServices;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class EndpointModelFixtures {
    private static final Endpoint.EndpointBuilder BASE_MODEL_ENDPOINT_V2 = Endpoint.builder().name("Endpoint name").target("http://gravitee.io").weight(1).backup(false).status(Endpoint.Status.UP).tenants(List.of("tenant1", "tenant2")).type("HTTP").inherit(Boolean.valueOf(true)).healthCheck(EndpointHealthCheckService.builder().build()).configuration(null);
    private static final EndpointGroup.EndpointGroupBuilder BASE_MODEL_ENDPOINTGROUP_V2 = io.gravitee.definition.model.EndpointGroup.builder().name("Endpoint group name").endpoints(Set.of(BASE_MODEL_ENDPOINT_V2.build())).loadBalancer(io.gravitee.definition.model.LoadBalancer.builder().type(io.gravitee.definition.model.LoadBalancerType.ROUND_ROBIN).build()).services(null).httpProxy(null).httpClientOptions(null).httpClientSslOptions(null).headers(Collections.emptyList());
    private static final Endpoint.EndpointBuilder BASE_MODEL_ENDPOINT_V4 = io.gravitee.definition.model.v4.endpointgroup.Endpoint.builder().name("Endpoint name").type("http-get").weight(1).inheritConfiguration(false).secondary(false).tenants(List.of("tenant1", "tenant2")).configuration("{\n  \"nice\" : \"configuration\"\n}").sharedConfigurationOverride("{\n  \"nice\" : \"configuration\"\n}").services(EndpointServices.builder().healthCheck(null).build());
    private static final EndpointGroup.EndpointGroupBuilder BASE_MODEL_ENDPOINTGROUP_V4 = EndpointGroup.builder().name("Endpoint group name").type("http-get").loadBalancer(LoadBalancer.builder().type(LoadBalancerType.ROUND_ROBIN).build()).sharedConfiguration("{\n  \"nice\" : \"configuration\"\n}").endpoints(List.of(BASE_MODEL_ENDPOINT_V4.build())).services(EndpointGroupServices.builder().healthCheck(null).build());

    private EndpointModelFixtures() {
    }

    public static Endpoint aModelEndpointV2() {
        return BASE_MODEL_ENDPOINT_V2.build();
    }

    public static io.gravitee.definition.model.EndpointGroup aModelEndpointGroupV2() {
        return BASE_MODEL_ENDPOINTGROUP_V2.build();
    }

    public static io.gravitee.definition.model.v4.endpointgroup.Endpoint aModelEndpointV4() {
        return BASE_MODEL_ENDPOINT_V4.build();
    }

    public static EndpointGroup aModelEndpointGroupV4() {
        return BASE_MODEL_ENDPOINTGROUP_V4.build();
    }
}

