/*
 * Decompiled with CFR 0.152.
 */
package fixtures;

import fixtures.EndpointModelFixtures;
import fixtures.FlowModelFixtures;
import fixtures.ListenerModelFixtures;
import fixtures.PrimaryOwnerModelFixtures;
import fixtures.PropertyModelFixtures;
import fixtures.ResourceModelFixtures;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.DefinitionContext;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.ResponseTemplate;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.services.Services;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.analytics.Analytics;
import io.gravitee.definition.model.v4.flow.execution.FlowExecution;
import io.gravitee.definition.model.v4.service.ApiServices;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApiModelFixtures {
    private static final DefinitionContext.DefinitionContextBuilder BASE_MODEL_DEFINITION_CONTEXT = DefinitionContext.builder().origin("management").mode("fully_managed");
    private static final ApiEntity.ApiEntityBuilder BASE_MODEL_API_V1 = ApiEntity.builder().graviteeDefinitionVersion(DefinitionVersion.V1.getLabel()).id("my-id").name("my-name").version("v1.0").properties(PropertyModelFixtures.aModelPropertiesV2()).services(new Services()).resources(List.of(ResourceModelFixtures.aResourceEntityV2())).responseTemplates(Map.of("key", new HashMap())).updatedAt(new Date()).paths(Map.of("path", List.of(new Rule())));
    private static final ApiEntity.ApiEntityBuilder BASE_MODEL_API_V2 = ApiEntity.builder().graviteeDefinitionVersion(DefinitionVersion.V2.getLabel()).id("my-id").name("my-name").version("v1.0").properties(PropertyModelFixtures.aModelPropertiesV2()).services(new Services()).resources(List.of(ResourceModelFixtures.aResourceEntityV2())).responseTemplates(Map.of("template-id", Map.of("application/json", new ResponseTemplate()))).updatedAt(new Date()).flows(List.of(FlowModelFixtures.aModelFlowV2()));
    private static final ApiEntity.ApiEntityBuilder BASE_MODEL_API_V4 = io.gravitee.rest.api.model.v4.api.ApiEntity.builder().id("my-id").crossId("my-cross-id").name("my-name").apiVersion("v1.0").definitionVersion(DefinitionVersion.V4).type(ApiType.PROXY).deployedAt(new Date()).createdAt(new Date()).updatedAt(new Date()).description("my-description").tags(Set.of("tag1", "tag2")).listeners(List.of(ListenerModelFixtures.aModelHttpListener(), ListenerModelFixtures.aModelSubscriptionListener(), ListenerModelFixtures.aModelTcpListener())).endpointGroups(List.of(EndpointModelFixtures.aModelEndpointGroupV4())).analytics(new Analytics()).properties(List.of(PropertyModelFixtures.aModelPropertyV4())).resources(List.of(ResourceModelFixtures.aResourceEntityV4())).flowExecution(new FlowExecution()).flows(List.of(FlowModelFixtures.aModelFlowV4())).responseTemplates(Map.of("template-id", Map.of("application/json", new ResponseTemplate()))).services(new ApiServices()).groups(Set.of("my-group1", "my-group2")).visibility(Visibility.PUBLIC).state(Lifecycle.State.STARTED).primaryOwner(PrimaryOwnerModelFixtures.aPrimaryOwnerEntity()).picture("my-picture").pictureUrl("my-picture-url").categories(Set.of("my-category1", "my-category2")).labels(List.of("my-label1", "my-label2")).definitionContext(BASE_MODEL_DEFINITION_CONTEXT.build()).metadata(Map.of("key", "value")).lifecycleState(ApiLifecycleState.CREATED).workflowState(WorkflowState.REVIEW_OK).disableMembershipNotifications(true).background("my-background").backgroundUrl("my-background-url");

    private ApiModelFixtures() {
    }

    public static ApiEntity aModelApiV1() {
        return BASE_MODEL_API_V1.build();
    }

    public static ApiEntity aModelApiV2() {
        return BASE_MODEL_API_V2.build();
    }

    public static io.gravitee.rest.api.model.v4.api.ApiEntity aModelApiV4() {
        return BASE_MODEL_API_V4.build();
    }

    public static GenericApiEntity aGenericApiEntity(DefinitionVersion definitionVersion) {
        return switch (definitionVersion) {
            default -> throw new IncompatibleClassChangeError();
            case DefinitionVersion.V1 -> ApiModelFixtures.aModelApiV1();
            case DefinitionVersion.V2 -> ApiModelFixtures.aModelApiV2();
            case DefinitionVersion.V4 -> ApiModelFixtures.aModelApiV4();
        };
    }
}

