/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.spec.converter.wsdl;

import io.gravitee.rest.api.spec.converter.wsdl.SoapBookmark;
import io.gravitee.rest.api.spec.converter.wsdl.WSDLUtils;
import io.gravitee.rest.api.spec.converter.wsdl.binding.SoapVersion;
import io.gravitee.rest.api.spec.converter.wsdl.soap.SoapBodyBuilder;
import io.gravitee.rest.api.spec.converter.wsdl.soap.SoapHeadersBuilder;
import io.gravitee.rest.api.spec.converter.wsdl.utils.SampleXmlUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.extensions.schema.Schema;
import lombok.Generated;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class SoapMessageBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SoapMessageBuilder.class);
    public static final String XMLSCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String XSD_PREFIX = "xsd";
    private final Map<String, String> namespaceMappings;
    private final Map<String, String> prefixToNamespaces;
    private final XmlOptions options;
    private List<XmlObject> schemas = new ArrayList<XmlObject>();
    private SchemaTypeSystem schemaTypeSystem;
    private boolean compiled = false;

    public SoapMessageBuilder(Map<String, String> namespaceMappings) {
        this.namespaceMappings = namespaceMappings;
        this.namespaceMappings.put(SampleXmlUtil.XSI_TYPE.getNamespaceURI(), SampleXmlUtil.XSI_TYPE.getPrefix());
        this.namespaceMappings.put(XMLSCHEMA, XSD_PREFIX);
        this.options = new XmlOptions();
        this.options.setLoadAdditionalNamespaces(this.namespaceMappings);
        this.options.setSavePrettyPrint();
        this.options.setSavePrettyPrintIndent(2);
        this.prefixToNamespaces = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : namespaceMappings.entrySet()) {
            this.prefixToNamespaces.put(entry.getValue(), entry.getKey());
        }
        this.options.setSaveSuggestedPrefixes(this.prefixToNamespaces);
    }

    public void addSchema(Schema schema) {
        try {
            this.schemas.add((XmlObject)XmlObject.Factory.parse((Node)schema.getElement(), this.options));
        }
        catch (XmlException e) {
            log.warn("XSD parsing failed, OpenAPI specification may be generated without SOAP envelope. Schema element: {}", (Object)schema.getElement(), (Object)e);
        }
    }

    public void compileSchemas() {
        try {
            this.schemaTypeSystem = XmlBeans.compileXsd((XmlObject[])this.schemas.toArray(new XmlObject[this.schemas.size()]), (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), (XmlOptions)this.options);
            this.compiled = true;
        }
        catch (XmlException e) {
            log.warn("Compilation of XSD failed, OpenAPI specification will be generated without SOAP envelope.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<String> generateSoapEnvelop(Definition wsdlDef, Binding binding, BindingOperation bindingOperation) {
        if (!this.compiled) {
            this.compileSchemas();
        }
        try (StringWriter writer = new StringWriter();){
            Optional<SoapVersion> optVersion = WSDLUtils.detectSoapVersion(binding.getExtensibilityElements());
            if (!optVersion.isPresent()) {
                log.error("SOAP version could not be detected for binding: {}. Skipping envelope generation.", (Object)binding.getQName());
                Optional<String> optional = Optional.empty();
                return optional;
            }
            SoapVersion version = optVersion.get();
            boolean useEncoded = version.useEncoded(bindingOperation);
            XmlObject soapEnvelope = (XmlObject)XmlObject.Factory.newInstance();
            SoapBookmark bookmark = new SoapBookmark();
            XmlCursor envelopeCursor = soapEnvelope.newCursor();
            envelopeCursor.toNextToken();
            envelopeCursor.beginElement(version.getEnvelopeQName());
            if (useEncoded) {
                envelopeCursor.insertNamespace(SampleXmlUtil.XSI_TYPE.getPrefix(), SampleXmlUtil.XSI_TYPE.getNamespaceURI());
                envelopeCursor.insertNamespace(XSD_PREFIX, XMLSCHEMA);
                envelopeCursor.insertAttributeWithValue(SampleXmlUtil.XSI_TYPE, WSDLUtils.formatQName(version.getEnvelopeQName()));
            }
            envelopeCursor.toLastChild();
            envelopeCursor.setBookmark((XmlCursor.XmlBookmark)bookmark);
            new SoapHeadersBuilder().withWsdlDef(wsdlDef).withBindingOperation(bindingOperation).withCursor(envelopeCursor).withNamespaceMappings(this.namespaceMappings).withShemaTypeSystem(this.schemaTypeSystem).withVersion(version).build();
            envelopeCursor.toBookmark((XmlCursor.XmlBookmark)bookmark);
            envelopeCursor.toLastChild();
            new SoapBodyBuilder().withBindingOperation(bindingOperation).withCursor(envelopeCursor).withNamespaceMappings(this.namespaceMappings).withShemaTypeSystem(this.schemaTypeSystem).withVersion(version).build();
            envelopeCursor.dispose();
            soapEnvelope.save((Writer)writer, this.options);
            writer.flush();
            Optional<String> optional = Optional.ofNullable(writer.toString());
            return optional;
        }
        catch (IOException e) {
            log.error("Generation of Soap Envelope failed for binding: {}", (Object)binding.getQName(), (Object)e);
            return Optional.empty();
        }
    }
}

