/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.spec.converter.wsdl.soap;

import io.gravitee.rest.api.spec.converter.wsdl.WSDLUtils;
import io.gravitee.rest.api.spec.converter.wsdl.binding.HeaderDef;
import io.gravitee.rest.api.spec.converter.wsdl.soap.AbstractSoapBuilder;
import io.gravitee.rest.api.spec.converter.wsdl.utils.SampleXmlUtil;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;

public class SoapHeadersBuilder
extends AbstractSoapBuilder {
    private Definition wsdlDef;

    public SoapHeadersBuilder withWsdlDef(Definition wsdlDef) {
        this.wsdlDef = wsdlDef;
        return this;
    }

    @Override
    public XmlCursor build() {
        if (this.version.hasHeadersElement(this.bindingOperation.getBindingInput().getExtensibilityElements())) {
            List<HeaderDef> headers = this.version.extractHeaderParts(this.bindingOperation.getBindingInput().getExtensibilityElements());
            for (HeaderDef header : headers) {
                this.generateHeader(header);
            }
        }
        return this.xmlCursor;
    }

    private void generateHeader(HeaderDef header) {
        QName actorQName;
        Object actor;
        Message msg = this.wsdlDef.getMessage(header.getMessage());
        Part part = msg.getPart(header.getPart());
        this.xmlCursor.beginElement(this.version.getHeaderQName());
        if (header.useEncoded()) {
            this.xmlCursor.insertAttributeWithValue(SampleXmlUtil.XSI_TYPE, WSDLUtils.formatQName(this.version.getHeaderQName()));
        }
        this.xmlCursor.toFirstChild();
        this.xmlCursor.beginElement(new QName(part.getName()));
        QName mustUnderstandQName = this.version.buildAttribute("mustUnderstand");
        Object mustUnderstand = part.getExtensionAttribute(mustUnderstandQName);
        if (mustUnderstand != null && mustUnderstand instanceof String) {
            this.xmlCursor.insertAttributeWithValue(mustUnderstandQName, (String)mustUnderstand);
        }
        if ((actor = part.getExtensionAttribute(actorQName = this.version.buildAttribute("actor"))) != null && actor instanceof String) {
            this.xmlCursor.insertAttributeWithValue(actorQName, (String)actor);
        }
        this.generateXml(part, this.xmlCursor, header.useEncoded());
        this.xmlCursor.toParent();
        this.xmlCursor.toParent();
    }
}

