/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.spec.converter.wsdl.reader;

import com.ibm.wsdl.xml.WSDLReaderImpl;
import java.io.IOException;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GraviteeWSDLReaderImpl
extends WSDLReaderImpl {
    private static final Logger logger = LoggerFactory.getLogger(GraviteeWSDLReaderImpl.class);

    public Definition readWSDL(String documentBaseURI, InputSource inputSource) throws WSDLException {
        String location = inputSource.getSystemId() != null ? inputSource.getSystemId() : "- WSDL Document -";
        return this.readWSDL(documentBaseURI, GraviteeWSDLReaderImpl.getDocument(inputSource, location));
    }

    private static Document getDocument(InputSource inputSource, String desc) throws WSDLException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        String FEATURE = null;
        try {
            FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
            dbf.setFeature(FEATURE, true);
            FEATURE = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(FEATURE, false);
            FEATURE = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(FEATURE, false);
            FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            dbf.setFeature(FEATURE, false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException e) {
            logger.info("ParserConfigurationException was thrown. The feature '" + FEATURE + "' is probably not supported by your XML processor.");
        }
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        try {
            DocumentBuilder safebuilder = dbf.newDocumentBuilder();
            return safebuilder.parse(inputSource);
        }
        catch (ParserConfigurationException e) {
            throw new WSDLException("PARSER_ERROR", "Problem parsing '" + desc + "'.", (Throwable)e);
        }
        catch (IOException e) {
            throw new WSDLException("IO_ERROR", "Problem parsing '" + desc + "'.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new WSDLException("SAX_ERROR", "Problem parsing '" + desc + "'.", (Throwable)e);
        }
    }
}

