/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.portal_page;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.portal_page.crud_service.PortalPageCrudService;
import io.gravitee.apim.core.portal_page.model.PageId;
import io.gravitee.apim.infra.adapter.PortalPageAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PortalPageRepository;
import io.gravitee.repository.management.model.PortalPage;
import java.util.List;
import java.util.Optional;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PortalPageCrudServiceImpl
implements PortalPageCrudService {
    private final PortalPageRepository portalPageRepository;
    private final PortalPageAdapter portalPageAdapter = PortalPageAdapter.INSTANCE;

    public PortalPageCrudServiceImpl(@Lazy PortalPageRepository portalPageRepository) {
        this.portalPageRepository = portalPageRepository;
    }

    @Override
    public List<io.gravitee.apim.core.portal_page.model.PortalPage> findByIds(List<PageId> pageIds) {
        return this.portalPageRepository.findByIds(pageIds.stream().map(PageId::toString).toList()).stream().map(this.portalPageAdapter::toEntity).toList();
    }

    @Override
    public io.gravitee.apim.core.portal_page.model.PortalPage update(io.gravitee.apim.core.portal_page.model.PortalPage page) {
        try {
            PortalPage repoPage = this.portalPageAdapter.toRepository(page);
            PortalPage updated = (PortalPage)this.portalPageRepository.update((Object)repoPage);
            return this.portalPageAdapter.toEntity(updated);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(e.getMessage(), e);
        }
    }

    @Override
    public Optional<io.gravitee.apim.core.portal_page.model.PortalPage> findById(PageId pageId) {
        try {
            return this.portalPageRepository.findById((Object)pageId.toString()).map(this.portalPageAdapter::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(e.getMessage(), e);
        }
    }
}

