/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.async_job.model.AsyncJob;
import io.gravitee.apim.infra.adapter.AsyncJobAdapter;
import io.gravitee.repository.management.model.AsyncJob;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public class AsyncJobAdapterImpl
implements AsyncJobAdapter {
    @Override
    public io.gravitee.apim.core.async_job.model.AsyncJob toEntity(AsyncJob source) {
        if (source == null) {
            return null;
        }
        AsyncJob.AsyncJobBuilder asyncJob = io.gravitee.apim.core.async_job.model.AsyncJob.builder();
        asyncJob.id(source.getId());
        asyncJob.sourceId(source.getSourceId());
        asyncJob.environmentId(source.getEnvironmentId());
        asyncJob.initiatorId(source.getInitiatorId());
        if (source.getType() != null) {
            asyncJob.type(Enum.valueOf(AsyncJob.Type.class, source.getType()));
        }
        if (source.getCreatedAt() != null) {
            asyncJob.createdAt(ZonedDateTime.ofInstant(source.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (source.getUpdatedAt() != null) {
            asyncJob.updatedAt(ZonedDateTime.ofInstant(source.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (source.getDeadLine() != null) {
            asyncJob.deadLine(ZonedDateTime.ofInstant(source.getDeadLine().toInstant(), ZoneId.systemDefault()));
        }
        if (source.getStatus() != null) {
            asyncJob.status(Enum.valueOf(AsyncJob.Status.class, source.getStatus()));
        }
        asyncJob.errorMessage(source.getErrorMessage());
        asyncJob.upperLimit(source.getUpperLimit());
        return asyncJob.build();
    }

    @Override
    public AsyncJob toRepository(io.gravitee.apim.core.async_job.model.AsyncJob source) {
        if (source == null) {
            return null;
        }
        AsyncJob.AsyncJobBuilder asyncJob = AsyncJob.builder();
        asyncJob.id(source.getId());
        asyncJob.sourceId(source.getSourceId());
        asyncJob.environmentId(source.getEnvironmentId());
        asyncJob.initiatorId(source.getInitiatorId());
        if (source.getType() != null) {
            asyncJob.type(source.getType().name());
        }
        if (source.getCreatedAt() != null) {
            asyncJob.createdAt(Date.from(source.getCreatedAt().toInstant()));
        }
        if (source.getUpdatedAt() != null) {
            asyncJob.updatedAt(Date.from(source.getUpdatedAt().toInstant()));
        }
        if (source.getDeadLine() != null) {
            asyncJob.deadLine(Date.from(source.getDeadLine().toInstant()));
        }
        if (source.getStatus() != null) {
            asyncJob.status(source.getStatus().name());
        }
        asyncJob.errorMessage(source.getErrorMessage());
        asyncJob.upperLimit(source.getUpperLimit());
        return asyncJob.build();
    }
}

