/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.cluster.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.EnvironmentAuditLogEntity;
import io.gravitee.apim.core.cluster.crud_service.ClusterCrudService;
import io.gravitee.apim.core.cluster.domain_service.ValidateClusterService;
import io.gravitee.apim.core.cluster.model.Cluster;
import io.gravitee.apim.core.cluster.model.ClusterAuditEvent;
import io.gravitee.apim.core.cluster.model.UpdateCluster;
import io.gravitee.apim.core.permission.domain_service.PermissionDomainService;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import java.util.Map;
import lombok.Generated;

@UseCase
public class UpdateClusterUseCase {
    private final ClusterCrudService clusterCrudService;
    private final ValidateClusterService validateClusterService;
    private final AuditDomainService auditService;
    private final PermissionDomainService permissionDomainService;

    public Output execute(Input input) {
        Cluster clusterToUpdate = this.clusterCrudService.findByIdAndEnvironmentId(input.clusterId, input.auditInfo.environmentId());
        if (!this.permissionDomainService.hasPermission(input.auditInfo.organizationId(), input.auditInfo.actor().userId(), RolePermission.CLUSTER_CONFIGURATION, input.clusterId, RolePermissionAction.UPDATE)) {
            input.updateCluster().setConfiguration(null);
        }
        clusterToUpdate.update(input.updateCluster());
        this.validateClusterService.validate(clusterToUpdate);
        Cluster updatedCluster = this.clusterCrudService.update(clusterToUpdate);
        this.createAuditLog(clusterToUpdate, updatedCluster, input.auditInfo());
        return new Output(updatedCluster);
    }

    private void createAuditLog(Cluster clusterBeforeUpdate, Cluster updatedCluster, AuditInfo auditInfo) {
        this.auditService.createEnvironmentAuditLog(EnvironmentAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).event(ClusterAuditEvent.CLUSTER_UPDATED).actor(auditInfo.actor()).oldValue(clusterBeforeUpdate).newValue(updatedCluster).createdAt(updatedCluster.getUpdatedAt().atZone(TimeProvider.clock().getZone())).properties(Map.of(AuditProperties.CLUSTER, updatedCluster.getId())).build());
    }

    @Generated
    public UpdateClusterUseCase(ClusterCrudService clusterCrudService, ValidateClusterService validateClusterService, AuditDomainService auditService, PermissionDomainService permissionDomainService) {
        this.clusterCrudService = clusterCrudService;
        this.validateClusterService = validateClusterService;
        this.auditService = auditService;
        this.permissionDomainService = permissionDomainService;
    }

    public record Input(String clusterId, UpdateCluster updateCluster, AuditInfo auditInfo) {
    }

    public record Output(Cluster cluster) {
    }
}

