/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.domain_service.ApiMetadataDecoderDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.query_service.ApiCategoryQueryService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.model.PrimaryOwnerApiTemplateData;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.exception.ApiPrimaryOwnerNotFoundException;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.search.Indexer;
import io.gravitee.apim.core.search.model.IndexableApi;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class ApiIndexerDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiIndexerDomainService.class);
    private final ApiMetadataDecoderDomainService apiMetadataDecoderDomainService;
    private final ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService;
    private final ApiCategoryQueryService apiCategoryQueryService;
    private final Indexer indexer;

    public ApiIndexerDomainService(ApiMetadataDecoderDomainService apiMetadataDecoderDomainService, ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService, ApiCategoryQueryService apiCategoryQueryService, Indexer indexer) {
        this.apiMetadataDecoderDomainService = apiMetadataDecoderDomainService;
        this.apiPrimaryOwnerDomainService = apiPrimaryOwnerDomainService;
        this.apiCategoryQueryService = apiCategoryQueryService;
        this.indexer = indexer;
    }

    public void index(Context context, Api apiToIndex, PrimaryOwnerEntity primaryOwner) {
        this.indexer.index(context.toIndexationContext(), this.toIndexableApi(apiToIndex, primaryOwner));
    }

    public void delete(Context context, Api apiToDelete) {
        Indexer.IndexationContext ctx = context.toIndexationContext();
        this.indexer.delete(ctx, this.toIndexableApi(ctx, apiToDelete));
    }

    private void commit() {
        this.indexer.commit();
    }

    public IndexableApi toIndexableApi(Indexer.IndexationContext context, Api apiToIndex) {
        try {
            PrimaryOwnerEntity primaryOwner = this.apiPrimaryOwnerDomainService.getApiPrimaryOwner(context.organizationId(), apiToIndex.getId());
            return this.toIndexableApi(apiToIndex, primaryOwner);
        }
        catch (ApiPrimaryOwnerNotFoundException e) {
            log.warn("Failed to retrieve API primary owner, API will we indexed without his primary owner", (Throwable)e);
            return this.toIndexableApi(apiToIndex, null);
        }
    }

    public IndexableApi toIndexableApi(Api apiToIndex, PrimaryOwnerEntity primaryOwner) {
        Map<String, String> metadata = this.apiMetadataDecoderDomainService.decodeMetadata(apiToIndex.getEnvironmentId(), apiToIndex.getId(), (ApiMetadataDecoderDomainService.ApiMetadataDecodeContext)((ApiMetadataDecoderDomainService.ApiMetadataDecodeContext.ApiMetadataDecodeContextBuilder)((ApiMetadataDecoderDomainService.ApiMetadataDecodeContext.ApiMetadataDecodeContextBuilder)((ApiMetadataDecoderDomainService.ApiMetadataDecodeContext.ApiMetadataDecodeContextBuilder)((ApiMetadataDecoderDomainService.ApiMetadataDecodeContext.ApiMetadataDecodeContextBuilder)((ApiMetadataDecoderDomainService.ApiMetadataDecodeContext.ApiMetadataDecodeContextBuilder)ApiMetadataDecoderDomainService.ApiMetadataDecodeContext.builder().name(apiToIndex.getName())).description(apiToIndex.getDescription())).createdAt(Date.from(apiToIndex.getCreatedAt().toInstant()))).updatedAt(Date.from(apiToIndex.getUpdatedAt().toInstant()))).primaryOwner(primaryOwner != null ? new PrimaryOwnerApiTemplateData(primaryOwner.id(), primaryOwner.displayName(), primaryOwner.email(), primaryOwner.type().name()) : null)).build());
        Collection<String> categoryKeys = this.apiCategoryQueryService.findApiCategoryKeys(apiToIndex);
        return new IndexableApi(apiToIndex, primaryOwner, metadata, categoryKeys);
    }

    public static Context oneShotIndexation(AuditInfo auditInfo) {
        return new Context(auditInfo, false);
    }

    public Bulk bulk(AuditInfo auditInfo) {
        return new Bulk(this, auditInfo);
    }

    public static class Context {
        private final Indexer.IndexationContext context;

        public Context(AuditInfo auditInfo, boolean bulk) {
            this.context = new Indexer.IndexationContext(auditInfo.organizationId(), auditInfo.environmentId(), !bulk);
        }

        Indexer.IndexationContext toIndexationContext() {
            return this.context;
        }
    }

    public record Bulk(ApiIndexerDomainService indexer, AuditInfo auditInfo) implements AutoCloseable,
    Supplier<Context>
    {
        @Override
        public void close() throws Exception {
            this.indexer.commit();
        }

        @Override
        public Context get() {
            return new Context(this.auditInfo, true);
        }
    }
}

