/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.node.api.upgrader.UpgraderException;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.rest.api.service.PortalPageService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class EnvironmentsDefaultPortalPageUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvironmentsDefaultPortalPageUpgrader.class);
    private final EnvironmentRepository environmentRepository;
    private final PortalPageService portalPageService;

    public EnvironmentsDefaultPortalPageUpgrader(@Lazy EnvironmentRepository environmentRepository, PortalPageService portalPageService) {
        this.environmentRepository = environmentRepository;
        this.portalPageService = portalPageService;
    }

    public int getOrder() {
        return 711;
    }

    public boolean upgrade() throws UpgraderException {
        try {
            for (Environment environment : this.environmentRepository.findAll()) {
                this.portalPageService.createDefaultPortalHomePage(environment.getId());
            }
            return true;
        }
        catch (TechnicalException e) {
            log.error("An error occurred while applying EnvironmentsDefaultPortalPageUpgrader upgrader", (Throwable)e);
            return false;
        }
    }
}

