/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.shared_policy_group.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.shared_policy_group.crud_service.SharedPolicyGroupCrudService;
import io.gravitee.apim.core.shared_policy_group.domain_service.ValidateCreateSharedPolicyGroupDomainService;
import io.gravitee.apim.core.shared_policy_group.domain_service.ValidateUpdateSharedPolicyGroupDomainService;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroupCRD;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.rest.api.service.common.IdBuilder;
import java.util.ArrayList;
import lombok.Generated;

@DomainService
public class ValidateSharedPolicyGroupCRDDomainService
implements Validator<Input> {
    private final SharedPolicyGroupCrudService sharedPolicyGroupCrudService;
    private final ValidateCreateSharedPolicyGroupDomainService validateCreateSharedPolicyGroupDomainService;
    private final ValidateUpdateSharedPolicyGroupDomainService validateUpdateSharedPolicyGroupDomainService;

    @Override
    public Validator.Result<Input> validateAndSanitize(Input input) {
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        if (input.crd().getCrossId() == null && input.crd().getHrid() == null) {
            errors.add(Validator.Error.severe("when no hrid is set in the payload a cross ID should be passed to identify the resource", new Object[0]));
            return Validator.Result.ofErrors(errors);
        }
        if (input.crd().getHrid() == null) {
            input.crd().setHrid(input.crd().getCrossId());
            idBuilder = IdBuilder.builder(input.auditInfo, input.crd.getCrossId());
            if (input.crd().getSharedPolicyGroupId() == null) {
                input.crd().setSharedPolicyGroupId(idBuilder.buildId());
            }
        } else {
            idBuilder = IdBuilder.builder(input.auditInfo, input.crd.getHrid());
            if (input.crd().getCrossId() == null) {
                input.crd().setCrossId(idBuilder.buildCrossId());
            }
            if (input.crd().getSharedPolicyGroupId() == null) {
                input.crd().setSharedPolicyGroupId(idBuilder.buildId());
            }
        }
        SharedPolicyGroupCRD.SharedPolicyGroupCRDBuilder sanitizedBuilder = input.crd.toBuilder();
        this.sharedPolicyGroupCrudService.findByEnvironmentIdAndCrossId(input.auditInfo.environmentId(), input.crd.getCrossId()).ifPresentOrElse(spg -> {
            input.crd.setSharedPolicyGroupId(spg.getId());
            this.validateUpdateSharedPolicyGroupDomainService.validateAndSanitize(new ValidateUpdateSharedPolicyGroupDomainService.Input(input.auditInfo, input.crd.toSharedPolicyGroup())).peek(i -> {}, errors::addAll);
        }, () -> this.validateCreateSharedPolicyGroupDomainService.validateAndSanitize(new ValidateCreateSharedPolicyGroupDomainService.Input(input.auditInfo, input.crd.toSharedPolicyGroup())).peek(i -> {}, errors::addAll));
        return Validator.Result.ofBoth(new Input(input.auditInfo(), sanitizedBuilder.build()), errors);
    }

    @Generated
    public ValidateSharedPolicyGroupCRDDomainService(SharedPolicyGroupCrudService sharedPolicyGroupCrudService, ValidateCreateSharedPolicyGroupDomainService validateCreateSharedPolicyGroupDomainService, ValidateUpdateSharedPolicyGroupDomainService validateUpdateSharedPolicyGroupDomainService) {
        this.sharedPolicyGroupCrudService = sharedPolicyGroupCrudService;
        this.validateCreateSharedPolicyGroupDomainService = validateCreateSharedPolicyGroupDomainService;
        this.validateUpdateSharedPolicyGroupDomainService = validateUpdateSharedPolicyGroupDomainService;
    }

    public record Input(AuditInfo auditInfo, SharedPolicyGroupCRD crd) implements Validator.Input
    {
    }
}

