/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.cluster.use_case.members;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.membership.domain_service.MembershipDomainService;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.permissions.ClusterPermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

@UseCase
public class GetClusterPermissionsUseCase {
    private final MembershipDomainService membershipDomainService;

    public Output execute(Input input) {
        Map<String, char[]> permissions = new HashMap<String, char[]>();
        if (input.isAuthenticated) {
            if (input.isAdmin) {
                char[] rights = new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()};
                for (ClusterPermission perm : ClusterPermission.values()) {
                    permissions.put(perm.getName(), rights);
                }
            } else {
                String username = input.authenticatedUser;
                ExecutionContext executionContext = GraviteeContext.getExecutionContext();
                permissions = this.membershipDomainService.getUserMemberPermissions(executionContext, MembershipReferenceType.CLUSTER, input.clusterId, username);
            }
        }
        return new Output(permissions);
    }

    @Generated
    public GetClusterPermissionsUseCase(MembershipDomainService membershipDomainService) {
        this.membershipDomainService = membershipDomainService;
    }

    public record Input(boolean isAuthenticated, boolean isAdmin, String authenticatedUser, String clusterId) {
    }

    public record Output(Map<String, char[]> permissions) {
    }
}

