/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.cluster.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.EnvironmentAuditLogEntity;
import io.gravitee.apim.core.cluster.crud_service.ClusterCrudService;
import io.gravitee.apim.core.cluster.model.ClusterAuditEvent;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

@UseCase
public class UpdateClusterGroupsUseCase {
    private final ClusterCrudService clusterCrudService;
    private final AuditDomainService auditService;

    public Output execute(Input input) {
        this.clusterCrudService.updateGroups(input.clusterId, input.auditInfo().environmentId(), input.groups());
        Set<String> updatedGroups = this.clusterCrudService.findByIdAndEnvironmentId(input.clusterId, input.auditInfo().environmentId()).getGroups();
        this.createAuditLog(updatedGroups, input.groups(), input.clusterId, input.auditInfo());
        return new Output(updatedGroups);
    }

    private void createAuditLog(Set<String> clusterGroupsBeforeUpdate, Set<String> clusterGroupsAfterUpdate, String clusterId, AuditInfo auditInfo) {
        this.auditService.createEnvironmentAuditLog(EnvironmentAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).event(ClusterAuditEvent.CLUSTER_GROUPS_UPDATED).actor(auditInfo.actor()).oldValue(clusterGroupsBeforeUpdate).newValue(clusterGroupsAfterUpdate).createdAt(Instant.now().atZone(ZoneId.of("UTC"))).properties(Map.of(AuditProperties.CLUSTER, clusterId)).build());
    }

    @Generated
    public UpdateClusterGroupsUseCase(ClusterCrudService clusterCrudService, AuditDomainService auditService) {
        this.clusterCrudService = clusterCrudService;
        this.auditService = auditService;
    }

    public record Input(String clusterId, Set<String> groups, AuditInfo auditInfo) {
    }

    public record Output(Set<String> groups) {
    }
}

