/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.model.ApiMetadata;
import io.gravitee.apim.core.api.model.NewApiMetadata;
import io.gravitee.apim.core.api.query_service.ApiMetadataQueryService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.ApiAuditEvent;
import io.gravitee.apim.core.metadata.crud_service.MetadataCrudService;
import io.gravitee.apim.core.metadata.model.Metadata;
import io.gravitee.apim.core.metadata.model.MetadataId;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.common.utils.IdGenerator;
import io.gravitee.common.utils.TimeProvider;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class ApiMetadataDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMetadataDomainService.class);
    private static final String EMAIL_SUPPORT_NAME = "email-support";
    private final MetadataCrudService metadataCrudService;
    private final ApiMetadataQueryService apiMetadataQueryService;
    private final AuditDomainService auditService;

    public void createDefaultApiMetadata(String apiId, AuditInfo auditInfo) {
        ZonedDateTime now = TimeProvider.now();
        Metadata emailSupportMetadata = this.metadataCrudService.create(Metadata.builder().key(IdGenerator.generate((String)EMAIL_SUPPORT_NAME)).format(Metadata.MetadataFormat.MAIL).name(EMAIL_SUPPORT_NAME).value("${(api.primaryOwner.email)!''}").referenceType(Metadata.ReferenceType.API).referenceId(apiId).createdAt(now).updatedAt(now).build());
        this.createAuditLog(emailSupportMetadata, ApiAuditEvent.METADATA_CREATED, auditInfo);
    }

    public void importApiMetadata(String apiId, List<ApiMetadata> metadata, AuditInfo auditInfo) {
        Map<String, ApiMetadata> previousMetadata = this.apiMetadataQueryService.findApiMetadata(auditInfo.environmentId(), apiId);
        this.importOrSave(apiId, metadata, auditInfo, previousMetadata.keySet());
    }

    public void saveApiMetadata(String apiId, List<ApiMetadata> metadata, AuditInfo auditInfo) {
        this.importOrSave(apiId, metadata, auditInfo, Set.of());
    }

    private void importOrSave(String apiId, List<ApiMetadata> metadata, AuditInfo auditInfo, Collection<String> previousMetadataKeys) {
        Set updated = CollectionUtils.stream(metadata).map(metadataEntry -> {
            metadataEntry.setApiId(apiId);
            this.createOrUpdateApiMetadataEntry(apiId, (ApiMetadata)metadataEntry, auditInfo);
            return metadataEntry.getKey();
        }).collect(Collectors.toSet());
        HashSet<String> toRemove = new HashSet<String>(previousMetadataKeys);
        toRemove.removeAll(updated);
        toRemove.remove(EMAIL_SUPPORT_NAME);
        toRemove.stream().map(old -> MetadataId.builder().key((String)old).referenceId(apiId).referenceType(Metadata.ReferenceType.API).build()).forEach(this.metadataCrudService::delete);
    }

    private void createOrUpdateApiMetadataEntry(String apiId, ApiMetadata metadataEntry, AuditInfo auditInfo) {
        MetadataId id = MetadataId.builder().key(metadataEntry.getKey()).referenceId(apiId).referenceType(Metadata.ReferenceType.API).build();
        this.metadataCrudService.findById(id).ifPresentOrElse(existing -> this.update(existing.toBuilder().name(metadataEntry.getName()).value(metadataEntry.getValue()).build(), auditInfo), () -> this.create(NewApiMetadata.builder().apiId(apiId).key(metadataEntry.getKey()).value(metadataEntry.getValue()).name(metadataEntry.getName()).format(metadataEntry.getFormat()).build(), auditInfo));
    }

    public ApiMetadata create(NewApiMetadata newApiMetadata, AuditInfo auditInfo) {
        ZonedDateTime now = TimeProvider.now();
        Metadata createdMetadata = this.metadataCrudService.create(Metadata.builder().key(newApiMetadata.getKey() != null ? newApiMetadata.getKey() : IdGenerator.generate((String)newApiMetadata.getName())).format(newApiMetadata.getFormat()).name(newApiMetadata.getName()).value(newApiMetadata.getValue()).referenceType(Metadata.ReferenceType.API).referenceId(newApiMetadata.getApiId()).createdAt(now).updatedAt(now).build());
        this.createAuditLog(createdMetadata, ApiAuditEvent.METADATA_CREATED, auditInfo);
        return this.toApiMetadata(auditInfo.environmentId(), createdMetadata);
    }

    public ApiMetadata update(Metadata metadata, AuditInfo auditInfo) {
        log.info("Update metadata [{}] for API [{}]", (Object)metadata.getKey(), (Object)metadata.getReferenceId());
        Metadata updatedMetadata = this.metadataCrudService.update(metadata.toBuilder().updatedAt(TimeProvider.now()).build());
        this.createAuditLog(updatedMetadata, ApiAuditEvent.METADATA_UPDATED, auditInfo);
        return this.toApiMetadata(auditInfo.environmentId(), updatedMetadata);
    }

    private void createAuditLog(Metadata created, ApiAuditEvent apiAuditEvent, AuditInfo auditInfo) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(created.getReferenceId()).event(apiAuditEvent).actor(auditInfo.actor()).newValue(created).createdAt(created.getCreatedAt()).properties(Map.of(AuditProperties.METADATA, created.getKey())).build());
    }

    private String findDefaultValue(String environmentId, String key) {
        return this.metadataCrudService.findById(MetadataId.builder().key(key).referenceId(environmentId).referenceType(Metadata.ReferenceType.ENVIRONMENT).build()).map(Metadata::getValue).orElse(null);
    }

    private ApiMetadata toApiMetadata(String environmentId, Metadata metadata) {
        return ApiMetadata.builder().key(metadata.getKey()).format(metadata.getFormat()).name(metadata.getName()).value(metadata.getValue()).defaultValue(this.findDefaultValue(environmentId, metadata.getKey())).apiId(metadata.getReferenceId()).build();
    }

    public void deleteApiMetadata(String apiId, AuditInfo auditInfo) {
        Map<String, ApiMetadata> metadataToDelete = this.apiMetadataQueryService.findApiMetadata(auditInfo.environmentId(), apiId);
        metadataToDelete.forEach((keyId, apiMetadata) -> {
            this.metadataCrudService.delete(this.toMetadataId((ApiMetadata)apiMetadata));
            this.createMetadataDeletedAuditLog((ApiMetadata)apiMetadata, auditInfo);
        });
    }

    private MetadataId toMetadataId(ApiMetadata apiMetadata) {
        return MetadataId.builder().key(apiMetadata.getKey()).referenceId(apiMetadata.getApiId()).referenceType(Metadata.ReferenceType.API).build();
    }

    private void createMetadataDeletedAuditLog(ApiMetadata apiMetadata, AuditInfo auditInfo) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(apiMetadata.getApiId()).event(ApiAuditEvent.METADATA_DELETED).actor(auditInfo.actor()).oldValue(apiMetadata).createdAt(TimeProvider.now()).properties(Map.of(AuditProperties.METADATA, apiMetadata.getKey())).build());
    }

    @Generated
    public ApiMetadataDomainService(MetadataCrudService metadataCrudService, ApiMetadataQueryService apiMetadataQueryService, AuditDomainService auditService) {
        this.metadataCrudService = metadataCrudService;
        this.apiMetadataQueryService = apiMetadataQueryService;
        this.auditService = auditService;
    }
}

