/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.analytics.domain_service.AnalyticsMetadataProvider;
import io.gravitee.apim.core.application.crud_service.ApplicationCrudService;
import io.gravitee.rest.api.model.BaseApplicationEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@DomainService
public class ApplicationMetadataProvider
implements AnalyticsMetadataProvider {
    private static final String METADATA_NAME = "name";
    private static final String METADATA_DELETED = "deleted";
    private static final String METADATA_UNKNOWN = "unknown";
    private static final String METADATA_UNKNOWN_APPLICATION_NAME = "Unknown application (keyless)";
    private static final String METADATA_DELETED_APPLICATION_NAME = "Deleted application";
    private static final String UNKNOWN_SERVICE = "1";
    private static final String UNKNOWN_SERVICE_MAPPED = "?";
    private static final String ARCHIVED = "ARCHIVED";
    private final ApplicationCrudService applicationCrudService;
    private static final ApplicationMetadata UNKNOWN_APPLICATION = new ApplicationMetadata("Unknown application (keyless)", true, false);
    private static final ApplicationMetadata NOT_FOUND = new ApplicationMetadata("Deleted application", false, true);

    public ApplicationMetadataProvider(ApplicationCrudService applicationCrudService) {
        this.applicationCrudService = applicationCrudService;
    }

    @Override
    public boolean appliesTo(AnalyticsMetadataProvider.Field field) {
        return field == AnalyticsMetadataProvider.Field.APPLICATION;
    }

    @Override
    public Map<String, String> provide(String key, String environmentId) {
        return this.provide(List.of(key), environmentId).getOrDefault(key, Map.of());
    }

    private static ApplicationMetadata ofApplication(BaseApplicationEntity app) {
        return new ApplicationMetadata(app.getName(), false, ARCHIVED.equals(app.getStatus()));
    }

    @Override
    public Map<String, Map<String, String>> provide(List<String> keys, String environmentId) {
        HashMap metaMap = new HashMap();
        keys.stream().filter(key -> UNKNOWN_SERVICE.equals(key) || UNKNOWN_SERVICE_MAPPED.equals(key)).forEach(key -> metaMap.put(key, UNKNOWN_APPLICATION));
        List<String> appIds = keys.stream().filter(key -> !UNKNOWN_SERVICE.equals(key) && !UNKNOWN_SERVICE_MAPPED.equals(key)).toList();
        if (!appIds.isEmpty()) {
            Map applications = this.applicationCrudService.findByIds(appIds, environmentId).stream().collect(Collectors.toMap(BaseApplicationEntity::getId, Function.identity()));
            applications.forEach((id, app) -> metaMap.put(id, ApplicationMetadataProvider.ofApplication(app)));
            appIds.stream().filter(id -> !applications.containsKey(id)).forEach(id -> metaMap.put(id, NOT_FOUND));
        }
        return metaMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ApplicationMetadata)entry.getValue()).toMap()));
    }

    record ApplicationMetadata(String name, boolean unknown, boolean deleted) {
        Map<String, String> toMap() {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put(ApplicationMetadataProvider.METADATA_NAME, this.name);
            if (this.unknown) {
                result.put(ApplicationMetadataProvider.METADATA_UNKNOWN, Boolean.TRUE.toString());
            }
            if (this.deleted) {
                result.put(ApplicationMetadataProvider.METADATA_DELETED, Boolean.TRUE.toString());
            }
            return result;
        }
    }
}

