/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.mapper;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.repository.management.model.Api;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.v4.mapper.ApiMapper;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class GenericApiMapper {
    private final ApiMapper apiMapper;
    private final ApiConverter apiConverter;

    public GenericApiEntity toGenericApi(Api api, PrimaryOwnerEntity primaryOwner) {
        return switch (this.getVersionOfDefault(api)) {
            default -> throw new MatchException(null, null);
            case DefinitionVersion.V4 -> {
                switch (api.getType()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NATIVE: {
                        yield this.apiMapper.toNativeEntity(api, primaryOwner);
                    }
                    case MESSAGE: 
                    case PROXY: 
                }
                yield this.apiMapper.toEntity(api, primaryOwner);
            }
            case DefinitionVersion.FEDERATED -> this.apiMapper.federatedToEntity(api, primaryOwner);
            case DefinitionVersion.FEDERATED_AGENT -> this.apiMapper.federatedAgentToEntity(api, primaryOwner);
            case DefinitionVersion.V1, DefinitionVersion.V2 -> this.apiConverter.toApiEntity(api, primaryOwner);
        };
    }

    public GenericApiEntity toGenericApi(ExecutionContext executionContext, Api api, PrimaryOwnerEntity primaryOwner) {
        return switch (this.getVersionOfDefault(api)) {
            default -> throw new MatchException(null, null);
            case DefinitionVersion.V4 -> {
                switch (api.getType()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NATIVE: {
                        yield this.apiMapper.toNativeEntity(executionContext, api, primaryOwner, true);
                    }
                    case MESSAGE: 
                    case PROXY: 
                }
                yield this.apiMapper.toEntity(executionContext, api, primaryOwner, true);
            }
            case DefinitionVersion.FEDERATED -> this.apiMapper.federatedToEntity(executionContext, api, primaryOwner);
            case DefinitionVersion.FEDERATED_AGENT -> this.apiMapper.federatedAgentToEntity(executionContext, api, primaryOwner);
            case DefinitionVersion.V1, DefinitionVersion.V2 -> this.apiConverter.toApiEntity(executionContext, api, primaryOwner, true);
        };
    }

    private DefinitionVersion getVersionOfDefault(Api api) {
        return api.getDefinitionVersion() == null ? DefinitionVersion.V2 : api.getDefinitionVersion();
    }

    @Generated
    public GenericApiMapper(ApiMapper apiMapper, ApiConverter apiConverter) {
        this.apiMapper = apiMapper;
        this.apiConverter = apiConverter;
    }
}

