/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.apim.core.api.model.Path;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.kubernetes.v1alpha1.ApiDefinitionResource;
import io.gravitee.kubernetes.mapper.CustomResource;
import io.gravitee.kubernetes.mapper.CustomResourceDefinitionMapper;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UpdatePageEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.kubernetes.v1alpha1.ApiExportQuery;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.ApiExportService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.converter.PlanConverter;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.jackson.ser.api.ApiSerializer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiExportServiceImpl
extends AbstractService
implements ApiExportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiExportServiceImpl.class);
    private final ObjectMapper objectMapper;
    private final PageService pageService;
    private final PlanService planService;
    private final ApiService apiService;
    private final RoleService roleService;
    private final ApiConverter apiConverter;
    private final PlanConverter planConverter;
    private final CustomResourceDefinitionMapper customResourceDefinitionMapper;

    public ApiExportServiceImpl(ObjectMapper objectMapper, PageService pageService, PlanService planService, ApiService apiService, RoleService roleService, ApiConverter apiConverter, PlanConverter planConverter, CustomResourceDefinitionMapper customResourceDefinitionMapper) {
        this.objectMapper = objectMapper;
        this.pageService = pageService;
        this.planService = planService;
        this.apiService = apiService;
        this.roleService = roleService;
        this.apiConverter = apiConverter;
        this.planConverter = planConverter;
        this.customResourceDefinitionMapper = customResourceDefinitionMapper;
    }

    @Override
    public String exportAsJson(ExecutionContext executionContext, String apiId, String exportVersion, String ... filteredFields) {
        ApiEntity apiEntity = this.getApi(executionContext, apiId, exportVersion, filteredFields);
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)apiEntity);
        }
        catch (Exception e) {
            LOGGER.error("An error occurs while trying to JSON serialize the API {}", (Object)apiEntity, (Object)e);
            return "";
        }
    }

    @Override
    public String exportAsCustomResourceDefinition(ExecutionContext executionContext, String apiId, ApiExportQuery exportQuery) {
        try {
            ApiEntity apiEntity = this.getApi(executionContext, apiId, "2.0.0", exportQuery.getExcludedFields());
            String json = this.objectMapper.writeValueAsString((Object)apiEntity);
            JsonNode jsonNode = this.objectMapper.readTree(json);
            String name = jsonNode.get("name").asText();
            ApiDefinitionResource apiDefinitionResource = new ApiDefinitionResource(name, (ObjectNode)jsonNode);
            if (apiDefinitionResource.hasMembers()) {
                this.mapCRDMembers(executionContext, apiDefinitionResource.getMembers());
            }
            if (apiDefinitionResource.hasPages()) {
                this.prepareApiPagesForExport(apiDefinitionResource.getPages());
            }
            apiDefinitionResource.setState(apiEntity.getState() == null ? Lifecycle.State.STOPPED.name() : apiEntity.getState().name());
            if (exportQuery.isRemoveIds()) {
                apiDefinitionResource.removeIds();
            }
            if (exportQuery.hasContextRef()) {
                apiDefinitionResource.setContextRef(exportQuery.getContextRefName(), exportQuery.getContextRefNamespace());
            }
            if (exportQuery.hasContextPath()) {
                String contextPath = Path.sanitizePath(exportQuery.getContextPath());
                apiDefinitionResource.setContextPath(contextPath);
            }
            if (exportQuery.hasVersion()) {
                apiDefinitionResource.setVersion(exportQuery.getVersion());
            }
            ((ObjectNode)jsonNode).set("notifyMembers", (JsonNode)BooleanNode.valueOf((!jsonNode.get("disable_membership_notifications").asBoolean() ? 1 : 0) != 0));
            ((ObjectNode)jsonNode).remove("disable_membership_notifications");
            return this.customResourceDefinitionMapper.toCustomResourceDefinition((CustomResource)apiDefinitionResource);
        }
        catch (Exception e) {
            LOGGER.error(String.format("An error occurs while trying to convert API %s to CRD", apiId), (Throwable)e);
            throw new TechnicalManagementException(e);
        }
    }

    private ApiEntity getApi(ExecutionContext executionContext, String apiId, String exportVersion, String ... filteredFields) {
        ApiEntity apiEntity = this.apiService.findById(executionContext, apiId);
        this.generateAndSaveCrossId(executionContext, apiEntity);
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put(ApiSerializer.METADATA_EXPORT_VERSION, exportVersion);
        metadata.put(ApiSerializer.METADATA_FILTERED_FIELDS_LIST, Arrays.asList(filteredFields));
        apiEntity.setMetadata(metadata);
        return apiEntity;
    }

    private void mapCRDMembers(ExecutionContext executionContext, ArrayNode members) {
        Map<String, String> roleIdToName = this.roleService.findByScope(RoleScope.API, executionContext.getOrganizationId()).stream().collect(Collectors.toMap(RoleEntity::getId, RoleEntity::getName));
        Iterator it = members.iterator();
        while (it.hasNext()) {
            JsonNode member = (JsonNode)it.next();
            JsonNode roles = member.get("roles");
            JsonNode roleId = (JsonNode)roles.iterator().next();
            String roleName = roleIdToName.get(roleId.asText());
            if (SystemRole.PRIMARY_OWNER.name().equals(roleName)) {
                it.remove();
                continue;
            }
            ((ObjectNode)member).remove("roles");
            ((ObjectNode)member).put("role", roleName);
        }
    }

    private void prepareApiPagesForExport(ObjectNode pages) throws JsonProcessingException {
        Iterator iterator = pages.fields();
        while (iterator.hasNext()) {
            Map.Entry pageJsonNode = (Map.Entry)iterator.next();
            PageEntity page = (PageEntity)this.objectMapper.treeToValue((TreeNode)pageJsonNode.getValue(), PageEntity.class);
            if ((PageType.MARKDOWN.name().equals(page.getType()) || PageType.SWAGGER.name().equals(page.getType())) && page.getSource() != null && "github-fetcher".equals(page.getSource().getType())) {
                if (page.getMetadata() != null && "auto_fetched".equals(page.getMetadata().get("graviteeio/fetcher_type"))) {
                    iterator.remove();
                    continue;
                }
                ((ObjectNode)pageJsonNode.getValue()).remove("content");
                ((ObjectNode)pageJsonNode.getValue()).remove("metadata");
                continue;
            }
            if (PageType.FOLDER.name().equals(page.getType()) && page.getSource() != null && "github-fetcher".equals(page.getSource().getType())) {
                iterator.remove();
                continue;
            }
            if (!PageType.SWAGGER.name().equals(page.getType()) && !PageType.MARKDOWN.name().equals(page.getType()) || page.getSource() == null || !"http-fetcher".equals(page.getSource().getType())) continue;
            ((ObjectNode)pageJsonNode.getValue()).remove("content");
            ((ObjectNode)pageJsonNode.getValue()).remove("metadata");
        }
    }

    private void generateAndSaveCrossId(ExecutionContext executionContext, ApiEntity api) {
        if (StringUtils.isEmpty((CharSequence)api.getCrossId())) {
            api.setCrossId(UuidString.generateRandom());
            this.apiService.update(executionContext, api.getId(), this.apiConverter.toUpdateApiEntity(api));
        }
        this.planService.findByApi(executionContext, api.getId()).forEach(plan -> this.generateAndSaveCrossId(executionContext, (PlanEntity)plan));
        this.pageService.findByApi(executionContext.getEnvironmentId(), api.getId()).forEach(page -> this.generateAndSaveCrossId(executionContext, (PageEntity)page));
    }

    private void generateAndSaveCrossId(ExecutionContext executionContext, PlanEntity plan) {
        if (StringUtils.isEmpty((CharSequence)plan.getCrossId())) {
            plan.setCrossId(UuidString.generateRandom());
            this.planService.update(executionContext, this.planConverter.toUpdatePlanEntity(plan));
        }
    }

    private void generateAndSaveCrossId(ExecutionContext executionContext, PageEntity page) {
        if (StringUtils.isEmpty((CharSequence)page.getCrossId())) {
            page.setCrossId(UuidString.generateRandom());
            UpdatePageEntity updatePageEntity = new UpdatePageEntity();
            updatePageEntity.setCrossId(page.getCrossId());
            this.pageService.update(executionContext, page.getId(), updatePageEntity, true);
        }
    }
}

