/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.bridge;

import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.bridge.BridgeCommand;
import io.gravitee.cockpit.api.command.v1.bridge.BridgeCommandPayload;
import io.gravitee.cockpit.api.command.v1.bridge.BridgeReply;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.rest.api.service.cockpit.command.bridge.operation.BridgeOperationHandler;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BridgeCommandHandler
implements CommandHandler<BridgeCommand, BridgeReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BridgeCommandHandler.class);
    private final List<BridgeOperationHandler> operationHandlers;
    private final BridgeOperationHandler noOperationHandler = new BridgeOperationHandler(this){

        @Override
        public boolean canHandle(String bridgeOperation) {
            return true;
        }

        @Override
        public Single<BridgeReply> handle(BridgeCommand command) {
            log.warn("No handler found for this operation {} ", (Object)((BridgeCommandPayload)command.getPayload()).operation());
            return Single.just((Object)new BridgeReply(command.getId(), "No handler found for this operation: " + ((BridgeCommandPayload)command.getPayload()).operation()));
        }
    };

    public String supportType() {
        return CockpitCommandType.BRIDGE.name();
    }

    public Single<BridgeReply> handle(BridgeCommand command) {
        return this.operationHandlers.stream().filter(handle -> handle.canHandle(((BridgeCommandPayload)command.getPayload()).operation())).findFirst().orElse(this.noOperationHandler).handle(command);
    }

    @Generated
    public BridgeCommandHandler(List<BridgeOperationHandler> operationHandlers) {
        this.operationHandlers = operationHandlers;
    }
}

