/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.scoring;

import io.gravitee.apim.core.scoring.model.ScoringRuleset;
import io.gravitee.apim.core.scoring.query_service.ScoringRulesetQueryService;
import io.gravitee.apim.infra.adapter.ScoringRulesetAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ScoringRulesetRepository;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ScoringRulesetQueryServiceImpl
extends AbstractService
implements ScoringRulesetQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScoringRulesetQueryServiceImpl.class);
    private final ScoringRulesetRepository scoringRulesetRepository;

    public ScoringRulesetQueryServiceImpl(@Lazy ScoringRulesetRepository scoringRulesetRepository) {
        this.scoringRulesetRepository = scoringRulesetRepository;
    }

    @Override
    public List<ScoringRuleset> findByReference(String referenceId, ScoringRuleset.ReferenceType referenceType) {
        try {
            return this.scoringRulesetRepository.findAllByReferenceId(referenceId, referenceType.name()).stream().map(ScoringRulesetAdapter.INSTANCE::toEntity).toList();
        }
        catch (TechnicalException e) {
            log.error("An error occurred while finding Scoring ruleset [{}:{}]", new Object[]{referenceType, referenceId, e});
            throw new TechnicalManagementException("An error occurred while finding Scoring ruleset [%s:%s] ".formatted(new Object[]{referenceType, referenceId}), e);
        }
    }
}

