/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.group.model.crd.GroupCRDSpec;
import io.gravitee.apim.core.member.model.RoleScope;
import io.gravitee.apim.core.member.model.crd.MemberCRD;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

@Mapper
public interface GroupCRDAdapter {
    public static final GroupCRDAdapter INSTANCE = (GroupCRDAdapter)Mappers.getMapper(GroupCRDAdapter.class);

    default public Set<MemberCRD> toApiMemberCRDSet(Set<GroupCRDSpec.Member> members) {
        return GroupCRDAdapter.toMemberCRDSet(members, RoleScope.API);
    }

    default public Set<MemberCRD> toApplicationMemberCRDSet(Set<GroupCRDSpec.Member> members) {
        return GroupCRDAdapter.toMemberCRDSet(members, RoleScope.APPLICATION);
    }

    default public Set<MemberCRD> toIntegrationMemberCRDSet(Set<GroupCRDSpec.Member> members) {
        return GroupCRDAdapter.toMemberCRDSet(members, RoleScope.INTEGRATION);
    }

    default public Set<GroupCRDSpec.Member> toGroupMembers(Set<MemberCRD> apiMembers) {
        HashMap<String, GroupCRDSpec.Member> groupMembers = new HashMap<String, GroupCRDSpec.Member>();
        for (MemberCRD member : apiMembers) {
            groupMembers.put(member.getId(), this.initGroupMember(member, RoleScope.API));
        }
        return new HashSet<GroupCRDSpec.Member>(groupMembers.values());
    }

    private GroupCRDSpec.Member initGroupMember(MemberCRD memberCRD, RoleScope roleScope) {
        HashMap<RoleScope, String> memberRoles = new HashMap<RoleScope, String>();
        memberRoles.put(roleScope, memberCRD.getRole());
        return new GroupCRDSpec.Member(memberCRD.getId(), memberCRD.getSourceId(), memberCRD.getSource(), memberRoles);
    }

    private static Set<MemberCRD> toMemberCRDSet(Set<GroupCRDSpec.Member> members, RoleScope roleScope) {
        return members.stream().flatMap(member -> member.getRoles().entrySet().stream().filter(roleEntry -> roleEntry.getKey() == roleScope).map(roleEntry -> new MemberCRD(member.getId(), member.getSource(), member.getSourceId(), (String)roleEntry.getValue()))).collect(Collectors.toSet());
    }
}

