/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.scoring.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.scoring.crud_service.ScoringRulesetCrudService;
import io.gravitee.apim.core.scoring.exception.RulesetNotFoundException;
import io.gravitee.apim.core.scoring.model.ScoringRuleset;
import io.gravitee.common.utils.TimeProvider;
import lombok.Generated;

@UseCase
public class UpdateEnvironmentRulesetUseCase {
    private final ScoringRulesetCrudService scoringRulesetCrudService;

    public Output execute(Input input) {
        ScoringRuleset found = this.scoringRulesetCrudService.findById(input.scoringRuleset.id()).filter(ruleset -> ruleset.referenceId().equals(input.auditInfo.environmentId())).orElseThrow(() -> new RulesetNotFoundException(input.scoringRuleset.id()));
        ScoringRuleset rulesetToUpdate = found.toBuilder().name(input.scoringRuleset.name()).description(input.scoringRuleset.description()).updatedAt(TimeProvider.now()).build();
        return new Output(this.scoringRulesetCrudService.update(rulesetToUpdate));
    }

    @Generated
    public UpdateEnvironmentRulesetUseCase(ScoringRulesetCrudService scoringRulesetCrudService) {
        this.scoringRulesetCrudService = scoringRulesetCrudService;
    }

    public record Input(ScoringRuleset scoringRuleset, AuditInfo auditInfo) {
    }

    public record Output(ScoringRuleset scoringRuleset) {
    }
}

