/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.scoring.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.scoring.model.EnvironmentApiScoringReport;
import io.gravitee.apim.core.scoring.query_service.ScoringReportQueryService;
import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import java.util.Optional;
import lombok.Generated;

@UseCase
public class GetEnvironmentReportsUseCase {
    private final ScoringReportQueryService scoringReportQueryService;

    public Output execute(Input input) {
        Pageable pageable = input.pageable.orElse((Pageable)new PageableImpl(1, 10));
        Page<EnvironmentApiScoringReport> result = this.scoringReportQueryService.findEnvironmentLatestReports(input.environmentId(), pageable);
        return new Output(result);
    }

    @Generated
    public GetEnvironmentReportsUseCase(ScoringReportQueryService scoringReportQueryService) {
        this.scoringReportQueryService = scoringReportQueryService;
    }

    public record Input(String environmentId, Optional<Pageable> pageable) {
        public Input(String environmentId) {
            this(environmentId, Optional.empty());
        }

        public Input(String environmentId, Pageable pageable) {
            this(environmentId, Optional.ofNullable(pageable));
        }
    }

    public record Output(Page<EnvironmentApiScoringReport> reports) {
    }
}

