/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.exception.NotAllowedDomainException;
import io.gravitee.apim.core.group.domain_service.ValidateGroupsDomainService;
import io.gravitee.apim.core.group.model.Group;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.exception.IntegrationGroupValidationException;
import io.gravitee.apim.core.integration.exception.IntegrationNotFoundException;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.license.domain_service.LicenseDomainService;
import io.gravitee.apim.core.validation.Validator;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class UpdateIntegrationUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateIntegrationUseCase.class);
    private final IntegrationCrudService integrationCrudService;
    private final LicenseDomainService licenseDomainService;
    private final ValidateGroupsDomainService validateGroupsDomainService;

    public Output execute(Input input) {
        Integration integration;
        if (!this.licenseDomainService.isFederationFeatureAllowed(input.auditInfo.organizationId())) {
            throw NotAllowedDomainException.noLicenseForFederation();
        }
        String integrationId = input.integrationId();
        Set<String> validatedGroups = this.validateGroups(input);
        Integration integration2 = integration = this.integrationCrudService.findById(integrationId).orElseThrow(() -> new IntegrationNotFoundException(integrationId));
        Objects.requireNonNull(integration2);
        Integration integration3 = integration2;
        int n = 0;
        Integration.ApiIntegration integrationToUpdate = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integration.ApiIntegration.class, Integration.A2aIntegration.class}, (Object)integration3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Integration.ApiIntegration apiIntegration = (Integration.ApiIntegration)integration3;
                yield apiIntegration.update(input.updateFields().name(), input.updateFields().description(), validatedGroups);
            }
            case 1 -> {
                Integration.A2aIntegration a2aIntegration = (Integration.A2aIntegration)integration3;
                yield a2aIntegration.update(input.updateFields().name(), input.updateFields().description(), validatedGroups, input.updateFields().wellKnownUrls());
            }
        };
        return new Output(this.integrationCrudService.update(integrationToUpdate));
    }

    private Set<String> validateGroups(Input input) {
        Validator.Result<ValidateGroupsDomainService.Input> validationResult = this.validateGroupsDomainService.validateAndSanitize(new ValidateGroupsDomainService.Input(input.auditInfo.environmentId(), input.updateFields().groups(), null, Group.GroupEvent.API_CREATE, false));
        if (validationResult.errors().isPresent() && !validationResult.errors().get().isEmpty()) {
            validationResult.errors().get().forEach(error -> log.error(error.getMessage(), error));
            throw new IntegrationGroupValidationException(input.integrationId());
        }
        return validationResult.value().isPresent() ? validationResult.value().get().groups() : Set.of();
    }

    @Generated
    public UpdateIntegrationUseCase(IntegrationCrudService integrationCrudService, LicenseDomainService licenseDomainService, ValidateGroupsDomainService validateGroupsDomainService) {
        this.integrationCrudService = integrationCrudService;
        this.licenseDomainService = licenseDomainService;
        this.validateGroupsDomainService = validateGroupsDomainService;
    }

    public record Input(String integrationId, UpdateFields updateFields, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        public record UpdateFields(String name, String description, Set<String> groups, Collection<Integration.A2aIntegration.WellKnownUrl> wellKnownUrls) {
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String integrationId;
            @Generated
            private UpdateFields updateFields;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder integrationId(String integrationId) {
                this.integrationId = integrationId;
                return this;
            }

            @Generated
            public InputBuilder updateFields(UpdateFields updateFields) {
                this.updateFields = updateFields;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.integrationId, this.updateFields, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "UpdateIntegrationUseCase.Input.InputBuilder(integrationId=" + this.integrationId + ", updateFields=" + String.valueOf(this.updateFields) + ", auditInfo=" + String.valueOf(this.auditInfo) + ")";
            }
        }
    }

    public record Output(Integration integration) {
    }
}

