/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.debug.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiPolicyValidatorDomainService;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.exception.InvalidPathsException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.debug.exceptions.DebugApiInvalidDefinitionVersionException;
import io.gravitee.apim.core.debug.exceptions.DebugApiNoCompatibleInstanceException;
import io.gravitee.apim.core.debug.exceptions.DebugApiNoValidPlanException;
import io.gravitee.apim.core.debug.model.ApiDebugStatus;
import io.gravitee.apim.core.event.crud_service.EventCrudService;
import io.gravitee.apim.core.event.model.Event;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.core.gateway.model.Instance;
import io.gravitee.apim.core.gateway.query_service.InstanceQueryService;
import io.gravitee.apim.core.plan.query_service.PlanQueryService;
import io.gravitee.common.util.EnvironmentUtils;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.HttpRequest;
import io.gravitee.definition.model.LoggingContent;
import io.gravitee.definition.model.LoggingMode;
import io.gravitee.definition.model.LoggingScope;
import io.gravitee.definition.model.Plan;
import io.gravitee.definition.model.debug.DebugApiProxy;
import io.gravitee.definition.model.debug.DebugApiV2;
import io.gravitee.definition.model.debug.DebugApiV4;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.endpointgroup.Endpoint;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.definition.model.v4.plan.AbstractPlan;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.rest.api.model.EventType;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class DebugApiUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DebugApiUseCase.class);
    private final ApiPolicyValidatorDomainService apiPolicyValidatorDomainService;
    private final ApiCrudService apiCrudService;
    private final InstanceQueryService instanceQueryService;
    private final PlanQueryService planQueryService;
    private final FlowCrudService flowCrudService;
    private final EventCrudService eventCrudService;

    public Output execute(Input input) throws InvalidPathsException {
        log.debug("Debugging API {}", (Object)input.apiId);
        if (input.debugApiV2 != null) {
            return new Output(this.handleEmbeddedDebugApiDefinition(input.debugApiV2, input.auditInfo));
        }
        if (input.debugApiRequest != null) {
            return new Output(this.handleDebugApi(input.apiId, input.debugApiRequest, input.auditInfo));
        }
        throw new IllegalArgumentException("Invalid input: either debugApiV2 or debugApiRequest must be provided");
    }

    private Event handleEmbeddedDebugApiDefinition(DebugApiV2 debugApiV2, AuditInfo auditInfo) {
        if (debugApiV2.getDefinitionVersion() != DefinitionVersion.V2) {
            throw new DebugApiInvalidDefinitionVersionException(debugApiV2.getId());
        }
        if (!this.apiCrudService.existsById(debugApiV2.getId())) {
            throw new ApiNotFoundException(debugApiV2.getId());
        }
        this.apiPolicyValidatorDomainService.checkPolicyConfigurations((DebugApiProxy)debugApiV2);
        Instance selectedGateway = this.selectTargetGateway(auditInfo.organizationId(), auditInfo.environmentId(), (DebugApiProxy)debugApiV2);
        DebugApiUseCase.validatePlans(debugApiV2.getId(), debugApiV2.getPlans(), null);
        DebugApiUseCase.disableLoggingForDebug((DebugApiProxy)debugApiV2);
        DebugApiUseCase.disableHealthCheckForDebug((DebugApiProxy)debugApiV2);
        return this.createDebugApiEvent(auditInfo, (DebugApiProxy)debugApiV2, selectedGateway);
    }

    private Event handleDebugApi(String apiId, HttpRequest debugRequest, AuditInfo auditInfo) {
        DebugApiProxy debugApi = this.validateApiExists(apiId, debugRequest);
        this.apiPolicyValidatorDomainService.checkPolicyConfigurations(debugApi);
        Instance selectedGateway = this.selectTargetGateway(auditInfo.organizationId(), auditInfo.environmentId(), debugApi);
        DebugApiUseCase.disableLoggingForDebug(debugApi);
        DebugApiUseCase.disableHealthCheckForDebug(debugApi);
        return this.createDebugApiEvent(auditInfo, debugApi, selectedGateway);
    }

    private DebugApiProxy validateApiExists(String apiId, HttpRequest debugApiRequest) {
        Api api = this.apiCrudService.findById(apiId).orElseThrow(() -> new ApiNotFoundException(apiId));
        return switch (api.getDefinitionVersion()) {
            case DefinitionVersion.V4 -> {
                if (api.getType() != ApiType.PROXY) {
                    throw new DebugApiInvalidDefinitionVersionException(apiId);
                }
                List<io.gravitee.definition.model.v4.plan.Plan> plans = this.planQueryService.findAllByApiId(apiId).stream().map(io.gravitee.apim.core.plan.model.Plan::getPlanDefinitionHttpV4).map(plan -> plan.flows(this.flowCrudService.getPlanV4Flows(plan.getId()))).toList();
                DebugApiUseCase.validatePlans(apiId, null, plans);
                yield new DebugApiV4(api.getApiDefinitionHttpV4().plans(plans).flow(this.flowCrudService.getApiV4Flows(apiId)), debugApiRequest);
            }
            case DefinitionVersion.V2 -> {
                List<Plan> plans = this.planQueryService.findAllByApiId(apiId).stream().map(io.gravitee.apim.core.plan.model.Plan::getPlanDefinitionV2).map(plan -> plan.flows(this.flowCrudService.getPlanV2Flows(plan.getId()))).toList();
                DebugApiUseCase.validatePlans(apiId, plans, null);
                yield new DebugApiV2(api.getApiDefinition().plans(plans).flows(this.flowCrudService.getApiV2Flows(apiId)), debugApiRequest);
            }
            default -> throw new DebugApiInvalidDefinitionVersionException(apiId);
        };
    }

    private Event createDebugApiEvent(AuditInfo auditInfo, DebugApiProxy debugApi, Instance selectedInstance) {
        EnumMap<Event.EventProperties, String> eventProperties = new EnumMap<Event.EventProperties, String>(Event.EventProperties.class);
        eventProperties.put(Event.EventProperties.USER, auditInfo.actor().userId());
        eventProperties.put(Event.EventProperties.API_DEBUG_STATUS, ApiDebugStatus.TO_DEBUG.name());
        eventProperties.put(Event.EventProperties.GATEWAY_ID, selectedInstance.getId());
        eventProperties.put(Event.EventProperties.API_ID, debugApi.getId());
        if (debugApi.getDefinitionVersion() == DefinitionVersion.V4) {
            eventProperties.put(Event.EventProperties.API_DEFINITION_VERSION, DefinitionVersion.V4.name());
        }
        return this.eventCrudService.createEvent(auditInfo.organizationId(), auditInfo.environmentId(), Set.of(auditInfo.environmentId()), EventType.DEBUG_API, debugApi, eventProperties);
    }

    private static void validatePlans(String apiId, List<Plan> plansV2, List<io.gravitee.definition.model.v4.plan.Plan> plansV4) {
        boolean hasValidPlan;
        if (plansV2 != null && !(hasValidPlan = plansV2.stream().anyMatch(plan -> io.gravitee.rest.api.model.PlanStatus.STAGING.name().equalsIgnoreCase(plan.getStatus()) || io.gravitee.rest.api.model.PlanStatus.PUBLISHED.name().equalsIgnoreCase(plan.getStatus())))) {
            throw new DebugApiNoValidPlanException(apiId);
        }
        if (plansV4 != null && !(hasValidPlan = plansV4.stream().map(AbstractPlan::getStatus).anyMatch(status -> status == PlanStatus.STAGING || status == PlanStatus.PUBLISHED))) {
            throw new DebugApiNoValidPlanException(apiId);
        }
    }

    private Instance selectTargetGateway(String organizationId, String environmentId, DebugApiProxy debugApi) {
        return this.instanceQueryService.findAllStarted(organizationId, environmentId).stream().filter(Instance::isClusterPrimaryNode).filter(instance -> instance.isRunningForEnvironment(environmentId)).filter(Instance::hasDebugPluginInstalled).filter(instance -> EnvironmentUtils.hasMatchingTags(Optional.ofNullable(instance.getTags()), (Set)debugApi.getTags())).max(Comparator.comparing(Instance::getStartedAt)).orElseThrow(() -> new DebugApiNoCompatibleInstanceException(debugApi.getId()));
    }

    private static void disableLoggingForDebug(DebugApiProxy debugApi) {
        DebugApiV4 debugApiV4;
        io.gravitee.definition.model.v4.Api apiDefinition;
        DebugApiV2 debugApiV2;
        if (debugApi instanceof DebugApiV2 && (debugApiV2 = (DebugApiV2)debugApi).getProxy() != null && debugApiV2.getProxy().getLogging() != null) {
            debugApiV2.getProxy().getLogging().setMode(LoggingMode.NONE);
            debugApiV2.getProxy().getLogging().setContent(LoggingContent.NONE);
            debugApiV2.getProxy().getLogging().setScope(LoggingScope.NONE);
        }
        if (debugApi instanceof DebugApiV4 && (apiDefinition = (debugApiV4 = (DebugApiV4)debugApi).getApiDefinition()).getAnalytics() != null) {
            apiDefinition.getAnalytics().setLogging(null);
        }
    }

    private static void disableHealthCheckForDebug(DebugApiProxy debugApi) {
        DebugApiV2 debugApiV2;
        if (debugApi instanceof DebugApiV2 && (debugApiV2 = (DebugApiV2)debugApi).getServices() != null && debugApiV2.getServices().getHealthCheckService() != null) {
            debugApiV2.getServices().getHealthCheckService().setEnabled(false);
        }
        if (debugApi instanceof DebugApiV4) {
            DebugApiV4 debugApiV4 = (DebugApiV4)debugApi;
            io.gravitee.definition.model.v4.Api apiDefinition = debugApiV4.getApiDefinition();
            apiDefinition.getEndpointGroups().stream().map(EndpointGroup::getServices).forEach(endpointGroupServices -> endpointGroupServices.setHealthCheck(null));
            apiDefinition.getEndpointGroups().stream().flatMap(group -> group.getEndpoints().stream()).map(Endpoint::getServices).forEach(endpointServices -> endpointServices.setHealthCheck(null));
        }
    }

    @Generated
    public DebugApiUseCase(ApiPolicyValidatorDomainService apiPolicyValidatorDomainService, ApiCrudService apiCrudService, InstanceQueryService instanceQueryService, PlanQueryService planQueryService, FlowCrudService flowCrudService, EventCrudService eventCrudService) {
        this.apiPolicyValidatorDomainService = apiPolicyValidatorDomainService;
        this.apiCrudService = apiCrudService;
        this.instanceQueryService = instanceQueryService;
        this.planQueryService = planQueryService;
        this.flowCrudService = flowCrudService;
        this.eventCrudService = eventCrudService;
    }

    public record Input(String apiId, DebugApiV2 debugApiV2, HttpRequest debugApiRequest, AuditInfo auditInfo) {
        public Input {
            Objects.requireNonNull(apiId);
            Objects.requireNonNull(auditInfo);
        }

        public Input(String apiId, HttpRequest debugApiRequest, AuditInfo auditInfo) {
            this(apiId, null, debugApiRequest, auditInfo);
            Objects.requireNonNull(debugApiRequest);
        }

        public Input(String apiId, DebugApiV2 debugApiV2, AuditInfo auditInfo) {
            this(apiId, debugApiV2, null, auditInfo);
            Objects.requireNonNull(debugApiV2);
        }
    }

    public record Output(Event debugApiEvent) {
    }
}

