/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.model.mapper;

import io.gravitee.definition.model.ssl.jks.JKSTrustStore;
import io.gravitee.definition.model.ssl.none.NoneTrustStore;
import io.gravitee.definition.model.ssl.pem.PEMTrustStore;
import io.gravitee.definition.model.ssl.pkcs12.PKCS12TrustStore;
import io.gravitee.definition.model.v4.ssl.TrustStore;
import java.lang.runtime.SwitchBootstraps;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public final class TrustStoreMigration {
    public static @Nullable TrustStore convert(@Nullable io.gravitee.definition.model.ssl.TrustStore v2TrustStore) {
        io.gravitee.definition.model.ssl.TrustStore trustStore = v2TrustStore;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JKSTrustStore.class, PEMTrustStore.class, PKCS12TrustStore.class, NoneTrustStore.class}, (Object)trustStore, n)) {
            case 0 -> {
                JKSTrustStore v2Jks = (JKSTrustStore)trustStore;
                yield TrustStoreMigration.convertJks(v2Jks);
            }
            case 1 -> {
                PEMTrustStore v2Pem = (PEMTrustStore)trustStore;
                yield TrustStoreMigration.convertPem(v2Pem);
            }
            case 2 -> {
                PKCS12TrustStore v2Pkcs12 = (PKCS12TrustStore)trustStore;
                yield TrustStoreMigration.convertPkcs12(v2Pkcs12);
            }
            case 3 -> {
                NoneTrustStore ignored = (NoneTrustStore)trustStore;
                yield TrustStoreMigration.convertNone();
            }
            case -1 -> null;
            default -> throw new IllegalArgumentException("Unsupported trust store type: " + String.valueOf(v2TrustStore.getClass()));
        };
    }

    private static io.gravitee.definition.model.v4.ssl.jks.JKSTrustStore convertJks(JKSTrustStore v2Jks) {
        return new io.gravitee.definition.model.v4.ssl.jks.JKSTrustStore(v2Jks.getPath(), v2Jks.getContent(), v2Jks.getPassword(), null);
    }

    private static io.gravitee.definition.model.v4.ssl.pem.PEMTrustStore convertPem(PEMTrustStore v2Pem) {
        return new io.gravitee.definition.model.v4.ssl.pem.PEMTrustStore(v2Pem.getPath(), v2Pem.getContent());
    }

    private static io.gravitee.definition.model.v4.ssl.pkcs12.PKCS12TrustStore convertPkcs12(PKCS12TrustStore v2Pkcs12) {
        io.gravitee.definition.model.v4.ssl.pkcs12.PKCS12TrustStore pKCS12TrustStore = new io.gravitee.definition.model.v4.ssl.pkcs12.PKCS12TrustStore();
        pKCS12TrustStore.setPath(v2Pkcs12.getPath());
        pKCS12TrustStore.setContent(v2Pkcs12.getContent());
        pKCS12TrustStore.setPassword(v2Pkcs12.getPassword());
        return pKCS12TrustStore;
    }

    private static io.gravitee.definition.model.v4.ssl.none.NoneTrustStore convertNone() {
        return new io.gravitee.definition.model.v4.ssl.none.NoneTrustStore();
    }

    @Generated
    private TrustStoreMigration() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

