/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.domain_service;

import io.gravitee.apim.core.analytics.exception.IllegalTimeRangeException;
import io.gravitee.apim.core.api.exception.ApiInvalidDefinitionVersionException;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.exception.TcpProxyNotSupportedException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.List;
import lombok.Generated;

public interface ApiAnalyticsSpecification {
    public boolean satisfies(Api var1, ExecutionContext var2, long var3, long var5);

    public void throwIfNotSatisfied(Api var1, ExecutionContext var2, long var3, long var5);

    public static ApiAnalyticsSpecification forSearchHistogramAnalytics() {
        return new And(List.of(new ApiV4Specification(), new ApiProxySpecification(), new ApiMultiTenancyAccessSpecification(), new TimeRangeSpecification()));
    }

    public static ApiAnalyticsSpecification forSearchGroupByAnalytics() {
        return new And(List.of(new ApiV4Specification(), new ApiProxySpecification(), new ApiMultiTenancyAccessSpecification(), new TimeRangeSpecification()));
    }

    public static ApiAnalyticsSpecification forRequestsCountAnalytics() {
        return new And(List.of(new ApiV4Specification(), new ApiProxySpecification(), new ApiMultiTenancyAccessSpecification(), new TimeRangeSpecification()));
    }

    public static ApiAnalyticsSpecification forSearchStatsAnalytics() {
        return new And(List.of(new ApiV4Specification(), new ApiProxySpecification(), new ApiMultiTenancyAccessSpecification(), new TimeRangeSpecification()));
    }

    public static class And
    implements ApiAnalyticsSpecification {
        private final List<ApiAnalyticsSpecification> specifications;

        @Override
        public boolean satisfies(Api api, ExecutionContext executionContext, long from, long to) {
            return this.specifications.stream().allMatch(spec -> spec.satisfies(api, executionContext, from, to));
        }

        @Override
        public void throwIfNotSatisfied(Api api, ExecutionContext executionContext, long from, long to) {
            this.specifications.forEach(spec -> spec.throwIfNotSatisfied(api, executionContext, from, to));
        }

        @Generated
        public And(List<ApiAnalyticsSpecification> specifications) {
            this.specifications = specifications;
        }
    }

    public static class ApiV4Specification
    implements ApiAnalyticsSpecification {
        @Override
        public boolean satisfies(Api api, ExecutionContext executionContext, long from, long to) {
            return api.getDefinitionVersion() == DefinitionVersion.V4;
        }

        @Override
        public void throwIfNotSatisfied(Api api, ExecutionContext executionContext, long from, long to) {
            if (!this.satisfies(api, executionContext, from, to)) {
                throw new ApiInvalidDefinitionVersionException(api.getId());
            }
        }
    }

    public static class ApiProxySpecification
    implements ApiAnalyticsSpecification {
        @Override
        public boolean satisfies(Api api, ExecutionContext executionContext, long from, long to) {
            return !api.isTcpProxy();
        }

        @Override
        public void throwIfNotSatisfied(Api api, ExecutionContext executionContext, long from, long to) {
            if (!this.satisfies(api, executionContext, from, to)) {
                throw new TcpProxyNotSupportedException(api.getId());
            }
        }
    }

    public static class ApiMultiTenancyAccessSpecification
    implements ApiAnalyticsSpecification {
        @Override
        public boolean satisfies(Api api, ExecutionContext executionContext, long from, long to) {
            return api.belongsToEnvironment(executionContext.getEnvironmentId());
        }

        @Override
        public void throwIfNotSatisfied(Api api, ExecutionContext executionContext, long from, long to) {
            if (!this.satisfies(api, executionContext, from, to)) {
                throw new ApiNotFoundException(api.getId());
            }
        }
    }

    public static class TimeRangeSpecification
    implements ApiAnalyticsSpecification {
        @Override
        public boolean satisfies(Api api, ExecutionContext executionContext, long from, long to) {
            return from <= to;
        }

        @Override
        public void throwIfNotSatisfied(Api api, ExecutionContext executionContext, long from, long to) {
            if (!this.satisfies(api, executionContext, from, to)) {
                throw new IllegalTimeRangeException();
            }
        }
    }
}

